/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.domain.debug;

import dk.cavi.eventbus.core.AbstractFilterInterface;
import dk.cavi.eventbus.core.EventConsumer;
import dk.cavi.eventbus.core.FilterInterface;
import dk.cavi.eventbus.core.annotations.AutoControlPanel;
import dk.cavi.eventbus.core.annotations.FilterDocumentation;
import dk.cavi.eventbus.core.annotations.SavedParameter;
import dk.cavi.eventbus.core.annotations.UIParameter;
import dk.cavi.eventbus.core.events.EventInterface;
import dk.cavi.eventbus.core.events.TimestampedEvent;
import dk.cavi.eventbus.domain.debug.ui.FrameDebugPanel;
import dk.cavi.xml.XMLNode;
import dk.cavi.xml.XMLSaver;
import java.util.Queue;
import javax.swing.JPanel;

@FilterDocumentation(shortDescription="Shows events as a printed string representation", tags="debug", help="Double click the filter to open the window containing the output.")
@AutoControlPanel
public class FrameDebugFilter<T extends EventInterface>
extends AbstractFilterInterface<T, T>
implements EventConsumer {
    private transient FrameDebugPanel debugPanel;
    private transient Queue<TimestampedEvent> displayQueue;
    private transient Thread ourThread;
    @SavedParameter
    @UIParameter(label="History size")
    private int historySize;
    @UIParameter(label="testDouble", stepSize=0.1, group=1, order=0)
    private double testDouble;
    @UIParameter(label="testShort", group=2)
    private short testShort;
    @UIParameter(label="testFloat", group=1, order=1)
    private float testFloat;
    @UIParameter(label="testBoolean", group=3)
    private boolean testBoolean;
    @UIParameter(label="testLong", group=2)
    private long testLong;
    @UIParameter(label="testString", group=3)
    private String testString;

    public void onInputEvent(T event, FilterInterface<?, T> source) {
        if (this.isEnabled() && this.debugPanel != null) {
            this.debugPanel.enqueueEvent((EventInterface)event);
        }
    }

    public JPanel defaultActionPanel() {
        return this.debugPanel;
    }

    protected void setupTransients() {
        this.debugPanel = new FrameDebugPanel(this.historySize, true);
    }

    public void destroy() {
        super.destroy();
    }

    protected void setupNewFilter() {
        this.historySize = 350;
    }

    protected void internalSaveToXML(XMLSaver xml) {
    }

    protected void internalLoadFromXML(XMLNode xml) {
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(int historySize) {
        this.historySize = historySize;
        if (this.debugPanel != null) {
            this.debugPanel.setHistorySize(historySize);
        }
    }
}

