/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.domain.debug.ui;

import dk.cavi.cavilog.CAVILog;
import dk.cavi.eventbus.core.events.EventInterface;
import dk.cavi.eventbus.core.events.TimestampedEvent;
import dk.cavi.eventbus.editor.CaviSwing;
import dk.cavi.eventbus.editor.DialogPanelUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class FrameDebugPanel
extends JPanel
implements Runnable {
    protected final DefaultTableModel debugModel;
    private final int DEFAULT_TIME_WIDTH = 95;
    private final int DEFAULT_TYPE_WIDTH = 90;
    protected final SimpleDateFormat dateFormatter;
    private int historySize;
    private int scrollTop;
    private final boolean skipWhileInvisible;
    private final ConcurrentLinkedQueue<TimestampedEvent> displayQueue;
    private final Thread ourThread;
    private JCheckBox autoScrollBox;
    private JTable debugTable;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private JButton jButton1;
    private JScrollPane jScrollPane2;
    private JToolBar jToolBar1;

    public FrameDebugPanel(int historySize, boolean skipWhileInvisible) {
        this.historySize = historySize;
        this.skipWhileInvisible = skipWhileInvisible;
        this.dateFormatter = new SimpleDateFormat("HH:mm:ss+SSS");
        this.initComponents();
        this.debugModel = new DefaultTableModel(new Object[0][], new String[]{"Time", "Type", "Identifier", "Data"});
        this.debugTable.setModel(this.debugModel);
        this.debugTable.getColumnModel().getColumn(0).setPreferredWidth(95);
        this.debugTable.getColumnModel().getColumn(0).setMaxWidth(95);
        this.debugTable.getColumnModel().getColumn(1).setPreferredWidth(90);
        this.debugTable.getColumnModel().getColumn(1).setMaxWidth(270);
        this.debugTable.getColumnModel().getColumn(2).setMaxWidth(150);
        this.jScrollPane2.getVerticalScrollBar().setUnitIncrement(20);
        this.displayQueue = new ConcurrentLinkedQueue();
        this.ourThread = new Thread(this);
        this.ourThread.setDaemon(true);
        this.ourThread.setName("FrameDebugPanel Thread");
        this.ourThread.start();
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jButton1 = new JButton();
        this.filler3 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.autoScrollBox = new JCheckBox();
        this.filler2 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.jScrollPane2 = new JScrollPane();
        this.debugTable = new JTable();
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.add(this.filler1);
        this.jButton1.setText("Clear");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameDebugPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.jToolBar1.add(this.filler3);
        this.autoScrollBox.setSelected(true);
        this.autoScrollBox.setText("Keep Scrolling");
        this.autoScrollBox.setFocusable(false);
        this.autoScrollBox.setHorizontalAlignment(2);
        this.autoScrollBox.setPreferredSize(new Dimension(162, 45));
        this.autoScrollBox.setVerticalTextPosition(3);
        this.autoScrollBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameDebugPanel.this.autoScrollBoxActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.autoScrollBox);
        this.jToolBar1.add(this.filler2);
        this.debugTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.debugTable.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.debugTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 1056, Short.MAX_VALUE).addComponent(this.jScrollPane2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 368, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar1, -2, 25, -2)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        while (this.debugModel.getRowCount() > 0) {
            this.debugModel.removeRow(0);
        }
    }

    private void autoScrollBoxActionPerformed(ActionEvent evt) {
    }

    public synchronized void onEventsBegin() {
        this.scrollTop = this.jScrollPane2.getVerticalScrollBar().getValue();
        this.debugModel.removeTableModelListener(this.debugTable);
    }

    public synchronized void onEvent(TimestampedEvent msg) {
        this.debugModel.addRow(new Object[]{this.dateFormatter.format(new Date(msg.getMillisecondTime())), msg.getEvent().getClass().getSimpleName(), msg.getEvent().getIdentifier(), msg.getEvent()});
    }

    public synchronized void onEventsEnd() {
        while (this.debugModel.getRowCount() > this.historySize) {
            this.scrollTop -= this.debugTable.getRowHeight();
            this.debugModel.removeRow(0);
        }
        CaviSwing.invokeAndWait(() -> {
            this.debugModel.addTableModelListener(this.debugTable);
            this.debugModel.fireTableDataChanged();
            if (this.autoScrollBox.isSelected()) {
                CaviSwing.invokeLater(() -> this.jScrollPane2.getVerticalScrollBar().setValue(Integer.MAX_VALUE));
            } else {
                this.jScrollPane2.getVerticalScrollBar().setValue(this.scrollTop);
            }
        });
    }

    public void setHistorySize(int size) {
        System.out.println("" + size);
        this.historySize = size;
    }

    public void clearHistory() {
        this.displayQueue.clear();
    }

    public void enqueueEvent(EventInterface event) {
        while (this.displayQueue.size() > this.historySize) {
            this.displayQueue.poll();
        }
        this.displayQueue.offer(new TimestampedEvent(event));
    }

    @Override
    public void run() {
        try {
            while (true) {
                Thread.sleep(20L);
                JDialog dialog = DialogPanelUtils.getDialogForPanel(this);
                if (dialog != null && dialog.isVisible()) {
                    TimestampedEvent e;
                    if (this.displayQueue.size() <= 0) continue;
                    this.onEventsBegin();
                    while ((e = this.displayQueue.poll()) != null) {
                        this.onEvent(e);
                    }
                    this.onEventsEnd();
                    continue;
                }
                if (!this.skipWhileInvisible) continue;
                this.clearHistory();
            }
        }
        catch (InterruptedException e) {
            CAVILog.logSimpleWarning((String)"FrameDebugFilter thread interrupted", (Throwable)e, (Object[])new Object[0]);
            return;
        }
    }
}

