/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.editor;

import dk.cavi.cavilog.CAVILog;
import dk.cavi.eventbus.core.FilterInterface;
import dk.cavi.eventbus.core.events.EventInterface;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassFinder {
    private static ClassFinder singleton;
    private final Set<String> availableClasses = new LinkedHashSet<String>();

    private ClassFinder() {
        System.out.println("Classfinder loading!");
        this.setupClassPathMap();
    }

    public static synchronized ClassFinder singleton() {
        if (singleton == null) {
            singleton = new ClassFinder();
        }
        return singleton;
    }

    private void setupClassPathMap() {
        String classPath = System.getProperty("java.class.path");
        String pathSeperator = System.getProperty("path.separator");
        classPath = classPath + pathSeperator + "./lib";
        StringTokenizer tokenizer = new StringTokenizer(classPath, pathSeperator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            File f = new File(path);
            if (f.isDirectory()) {
                this.includeDir(f, "");
                continue;
            }
            if (!f.getName().endsWith(".jar")) continue;
            try {
                JarFile jar = new JarFile(f);
                this.includeJar(jar);
            }
            catch (IOException ex) {
                CAVILog.logSimpleWarning(null, (Throwable)ex, (Object[])new Object[0]);
            }
        }
    }

    private void includeDir(File classDir, String prefix) {
        for (File f : classDir.listFiles()) {
            String foundClass;
            if (f.isDirectory()) {
                this.includeDir(f, prefix + f.getName() + ".");
                continue;
            }
            if (f.getName().endsWith(".jar")) {
                try {
                    this.includeJar(new JarFile(f));
                }
                catch (IOException ex) {
                    Logger.getLogger(ClassFinder.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            if (!f.getName().endsWith(".class") || !(foundClass = prefix + f.getName().substring(0, f.getName().lastIndexOf(46))).startsWith("dk.cavi.eventbus")) continue;
            try {
                Class<?> c = Class.forName(foundClass);
                if (FilterInterface.class.isAssignableFrom(c)) {
                    this.availableClasses.add(foundClass);
                }
                if (!EventInterface.class.isAssignableFrom(c)) continue;
                this.availableClasses.add(foundClass);
            }
            catch (Throwable ex) {
                Logger.getLogger(ClassFinder.class.getName()).log(Level.SEVERE, "Could not get class [" + foundClass + "] from file: " + f.getName(), ex);
            }
        }
    }

    private void includeJar(JarFile jar) {
        for (JarEntry entry : Collections.list(jar.entries())) {
            if (!entry.getName().endsWith(".class")) continue;
            String foundPath = entry.getName().substring(0, entry.getName().lastIndexOf(46));
            if (!(foundPath = foundPath.replaceAll("/", ".")).startsWith("dk.cavi.eventbus")) continue;
            try {
                Class<?> c = Class.forName(foundPath);
                if (FilterInterface.class.isAssignableFrom(c)) {
                    this.availableClasses.add(foundPath);
                }
                if (!EventInterface.class.isAssignableFrom(c)) continue;
                this.availableClasses.add(foundPath);
            }
            catch (Throwable ex) {
                Logger.getLogger(ClassFinder.class.getName()).log(Level.SEVERE, "Could not get class [" + foundPath + "] from file: " + jar.getName(), ex);
            }
        }
    }

    public List<Class<?>> findSubclasses(Class superClass) {
        LinkedList foundSubclasses = new LinkedList();
        for (String className : this.availableClasses) {
            try {
                Class<?> candidateSubclass = Class.forName(className, false, ClassFinder.class.getClassLoader());
                if (!superClass.isAssignableFrom(candidateSubclass) || superClass == candidateSubclass) continue;
                Class.forName(className, true, ClassFinder.class.getClassLoader());
                foundSubclasses.add(candidateSubclass);
            }
            catch (Throwable ex) {
                CAVILog.logSimpleWarning((String)("Origin class " + className), (Throwable)ex, (Object[])new Object[0]);
            }
        }
        return foundSubclasses;
    }

    public List<Class<?>> findClassesFromSimpleName(String className) {
        LinkedList foundClasses = new LinkedList();
        for (String candidateClassName : this.availableClasses) {
            if (!candidateClassName.endsWith("." + className)) continue;
            try {
                Class<?> foundClass = Class.forName(candidateClassName, true, ClassFinder.class.getClassLoader());
                foundClasses.add(foundClass);
            }
            catch (Throwable ex) {
                CAVILog.logSimpleWarning((String)("Could not find or instantiate a class that matched search pattern " + className), (Throwable)ex, (Object[])new Object[0]);
            }
        }
        return foundClasses;
    }
}

