/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.editor;

import dk.cavi.eventbus.core.annotations.FilterDocumentation;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DocumentationHelper {
    public static String getDescriptionHTMLBody(String classPath) {
        try {
            return DocumentationHelper.getSimpleHTML(Class.forName(classPath));
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DocumentationHelper.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static String getSimpleHTML(Class theClass) {
        FilterDocumentation documentation = theClass.getAnnotation(FilterDocumentation.class);
        if (documentation != null && documentation.shortDescription() != null && !documentation.shortDescription().isEmpty()) {
            String tags = documentation.tags() != null ? documentation.tags() : "";
            return "<div style='font-weight: bold'>" + theClass.getSimpleName() + "</div>" + documentation.shortDescription() + (tags.isEmpty() ? "" : "<br /><br />Tags: <b><i>" + tags + "</i></b>");
        }
        return null;
    }

    public static String getHelpHTML(Class theClass) {
        FilterDocumentation documentation = theClass.getAnnotation(FilterDocumentation.class);
        String simpleHTML = DocumentationHelper.getSimpleHTML(theClass);
        if (documentation != null && !documentation.help().isEmpty()) {
            String documentationHelp = documentation.help();
            URL imageURL = DocumentationHelper.class.getResource("/images/documentation/filters/" + theClass.getSimpleName());
            if (imageURL != null) {
                documentationHelp = documentationHelp.replaceAll("%docu_img_prefix%", imageURL.toString());
            }
            return simpleHTML + "<br /><br /><div style='font-weight: bold'>Setup and Settings</div>" + documentationHelp + "<br />";
        }
        return simpleHTML;
    }

    public static String getFieldPopupHTML(String title, String contents) {
        return "<html><body width=200><div style='font-weight: bold'>" + title + "</div>" + contents + "<br /></body></html>";
    }
}

