/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.editor;

import dk.cavi.eventbus.core.serialization.Serializer;
import dk.cavi.eventbus.core.serialization.SerializerConfigurable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class SerializerSelectorComponent
extends JPanel {
    private final SerializerConfigurable configurable;
    private boolean isUpdating = true;
    private final List<SelectableSerializer> serializers;
    private JComboBox<SelectableSerializer> jComboBox1;
    private JLabel jLabel2;

    public SerializerSelectorComponent(SerializerConfigurable configurable, List<Serializer> selectableSerializers) {
        this.configurable = configurable;
        this.serializers = new ArrayList<SelectableSerializer>();
        Serializer currentSerializer = configurable.getSerializer();
        SelectableSerializer currentSelectable = new SelectableSerializer(currentSerializer);
        for (Serializer serializer : selectableSerializers) {
            if (serializer.getClass().getCanonicalName().equals(currentSerializer.getClass().getCanonicalName())) {
                this.serializers.add(currentSelectable);
                continue;
            }
            this.serializers.add(new SelectableSerializer(serializer));
        }
        this.initComponents();
        this.jComboBox1.setSelectedItem(currentSelectable);
        this.isUpdating = false;
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox<SelectableSerializer>(this.serializers.toArray(new SelectableSerializer[0]));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("serializer");
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerializerSelectorComponent.this.jComboBox1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, 0, 132, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBox1, -2, -1, -2)));
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        if (!this.isUpdating && this.configurable.getSerializer() != this.jComboBox1.getSelectedItem()) {
            this.configurable.setSerializer(((SelectableSerializer)this.jComboBox1.getSelectedItem()).getSerializer());
        }
    }

    private static class SelectableSerializer {
        private final Serializer serializer;

        private SelectableSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public String toString() {
            return this.serializer.getFriendlyName();
        }

        public Serializer getSerializer() {
            return this.serializer;
        }
    }
}

