/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.core.marshalling;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import dk.cavi.cavilog.CAVILog;
import dk.cavi.eventbus.core.events.EventInterface;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class EventInterfaceTypeAdapterFactory
implements TypeAdapterFactory {
    public static final String EVENTBUS_TYPE_FIELD = "_eventbusClass";

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!EventInterface.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        EventInterfaceTypeAdapter result = new EventInterfaceTypeAdapter(gson, gson.getDelegateAdapter((TypeAdapterFactory)this, type));
        return result.nullSafe();
    }

    private class EventInterfaceTypeAdapter<EventInterface>
    extends TypeAdapter<EventInterface> {
        private final Gson gson;
        private final TypeAdapter theirStandardAdapter;

        public EventInterfaceTypeAdapter(Gson gson, TypeAdapter theirStandardAdapter) {
            this.gson = gson;
            this.theirStandardAdapter = theirStandardAdapter;
        }

        public void write(JsonWriter out, EventInterface value) throws IOException {
            JsonObject object = this.theirStandardAdapter.toJsonTree(value).getAsJsonObject();
            JsonObject ourObject = new JsonObject();
            ourObject.addProperty(EventInterfaceTypeAdapterFactory.EVENTBUS_TYPE_FIELD, value.getClass().getCanonicalName());
            Object[] fields = object.entrySet().toArray(new Map.Entry[0]);
            ArrayUtils.reverse((Object[])fields);
            for (Object entry : fields) {
                ourObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            Streams.write((JsonElement)ourObject, (JsonWriter)out);
        }

        public EventInterface read(JsonReader in) throws IOException {
            JsonObject object = Streams.parse((JsonReader)in).getAsJsonObject();
            if (object.has(EventInterfaceTypeAdapterFactory.EVENTBUS_TYPE_FIELD)) {
                String className = object.get(EventInterfaceTypeAdapterFactory.EVENTBUS_TYPE_FIELD).getAsString();
                try {
                    Class<?> clz = Class.forName(className);
                    return (EventInterface)this.gson.getDelegateAdapter((TypeAdapterFactory)EventInterfaceTypeAdapterFactory.this, TypeToken.get(clz)).fromJsonTree((JsonElement)object);
                }
                catch (JsonSyntaxException | ClassNotFoundException e) {
                    CAVILog.logSimpleWarning((String)"Error when reading EventInterface from json stream", (Throwable)e, (Object[])new Object[0]);
                }
            }
            return null;
        }
    }
}

