/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.core.serialization;

import dk.cavi.eventbus.core.serialization.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;

public class JavaSerializer
implements Serializer {
    @Override
    public String getFriendlyName() {
        return "Java (Built-In)";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray(Object theObject) throws NotSerializableException {
        try (ByteArrayOutputStream outBytes = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream outObj = new ObjectOutputStream(outBytes);){
                outObj.writeObject(theObject);
                outObj.close();
                outBytes.close();
                byArray = outBytes.toByteArray();
            }
            return byArray;
        }
        catch (IOException ex) {
            NotSerializableException ex2 = new NotSerializableException("Couldn't Java-serialize " + theObject.getClass() + " into a byte-array");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    @Override
    public int toByteBuffer(Object theObject, ByteBuffer targetBuffer) throws NotSerializableException {
        byte[] data = this.toByteArray(theObject);
        targetBuffer.put(data);
        return data.length;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T toObject(byte[] objByteArray) throws NotSerializableException {
        try (ByteArrayInputStream bin = new ByteArrayInputStream(objByteArray);){
            Object object;
            try (ObjectInputStream oin = new ObjectInputStream(bin);){
                object = oin.readObject();
            }
            return (T)object;
        }
        catch (Exception ex) {
            NotSerializableException ex2 = new NotSerializableException("Couldn't Java-deserialize");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    @Override
    public <T> T toObject(ByteBuffer objBuffer, int objSize) throws NotSerializableException {
        byte[] objArray = new byte[objSize];
        objBuffer.get(objArray);
        return this.toObject(objArray);
    }
}

