/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.core.serialization;

import dk.cavi.eventbus.core.serialization.FSTSerializer;
import dk.cavi.eventbus.core.serialization.FSTSerializerPreferSpeed;
import dk.cavi.eventbus.core.serialization.JavaSerializer;
import java.io.NotSerializableException;
import java.nio.ByteBuffer;

public interface Serializer {
    public String getFriendlyName();

    public byte[] toByteArray(Object var1) throws NotSerializableException;

    public int toByteBuffer(Object var1, ByteBuffer var2) throws NotSerializableException;

    public <T> T toObject(byte[] var1) throws NotSerializableException;

    public <T> T toObject(ByteBuffer var1, int var2) throws NotSerializableException;

    public static Serializer valueOf(String serializerName) {
        try {
            return (Serializer)Class.forName(serializerName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            return new FSTSerializer();
        }
    }

    public static Serializer[] values() {
        Serializer[] values = new Serializer[]{new FSTSerializer(), new FSTSerializerPreferSpeed(), new JavaSerializer()};
        return values;
    }
}

