/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.xml;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDNav;
import dk.cavi.xml.XMLLoader;
import java.util.ArrayList;
import java.util.List;

public class XMLNode {
    private final VTDNav nav;
    private final AutoPilot autoPilot;

    public XMLNode(VTDNav nav) {
        this.nav = nav;
        this.autoPilot = new AutoPilot(nav);
    }

    public String getString(String xmlPath, String fallback) {
        try {
            String value = this.getString(xmlPath);
            if (value != null) {
                return this.getString(xmlPath);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String xmlPath) {
        try {
            this.nav.push();
            this.autoPilot.selectXPath(xmlPath);
            String result = this.autoPilot.evalXPathToString();
            int index = -1;
            index = this.autoPilot.evalXPath();
            if (index != -1) {
                if (this.nav.getTokenType(index) == 5) {
                    String string = XMLLoader.unescape(result.trim());
                    return string;
                }
                String string = XMLLoader.unescape(result);
                return string;
            }
        }
        catch (Exception e) {
            System.out.println("Error parsing xml: " + e);
        }
        finally {
            this.autoPilot.resetXPath();
            this.nav.pop();
        }
        return null;
    }

    public double getDouble(String xmlPath) {
        return Double.parseDouble(this.getString(xmlPath));
    }

    public double getDouble(String xmlPath, double fallback) {
        try {
            return this.getDouble(xmlPath);
        }
        catch (Exception t) {
            return fallback;
        }
    }

    public long getLong(String xmlPath) {
        return Long.parseLong(this.getString(xmlPath));
    }

    public long getLong(String xmlPath, long fallback) {
        try {
            return this.getLong(xmlPath);
        }
        catch (Exception t) {
            return fallback;
        }
    }

    public int getInt(String xmlPath) {
        return Integer.parseInt(this.getString(xmlPath));
    }

    public int getInt(String xmlPath, int fallback) {
        try {
            return this.getInt(xmlPath);
        }
        catch (Exception t) {
            return fallback;
        }
    }

    public short getShort(String xmlPath) {
        return Short.parseShort(this.getString(xmlPath));
    }

    public short getShort(String xmlPath, short fallback) {
        try {
            return this.getShort(xmlPath);
        }
        catch (Exception t) {
            return fallback;
        }
    }

    public float getFloat(String xmlPath) {
        return Float.parseFloat(this.getString(xmlPath));
    }

    public float getFloat(String xmlPath, float fallback) {
        try {
            return this.getFloat(xmlPath);
        }
        catch (Exception t) {
            return fallback;
        }
    }

    public boolean getBoolean(String xmlPath) {
        return Boolean.parseBoolean(this.getString(xmlPath));
    }

    public boolean getBoolean(String xmlPath, boolean fallback) {
        try {
            return this.getBoolean(xmlPath);
        }
        catch (Exception t) {
            return fallback;
        }
    }

    public XMLNode getNode(String xmlPath) {
        this.nav.push();
        try {
            this.autoPilot.selectXPath(xmlPath);
            if (this.autoPilot.evalXPath() != -1) {
                XMLNode xMLNode = new XMLNode(this.nav.cloneNav());
                return xMLNode;
            }
        }
        catch (Exception e) {
            System.out.println("Error parsing xml: " + e);
        }
        finally {
            this.autoPilot.resetXPath();
            this.nav.pop();
        }
        return null;
    }

    public List<XMLNode> getNodes(String xmlPath) {
        ArrayList<XMLNode> result = new ArrayList<XMLNode>();
        this.nav.push();
        try {
            this.autoPilot.selectXPath(xmlPath);
            while (this.autoPilot.evalXPath() != -1) {
                result.add(new XMLNode(this.nav.cloneNav()));
            }
        }
        catch (Exception e) {
            System.out.println("Error parsing xml: " + e);
        }
        this.autoPilot.resetXPath();
        this.nav.pop();
        return result;
    }

    public <T> T loadVariable(String name, T fallback) {
        System.out.println("" + fallback.getClass());
        if (fallback instanceof Double) {
            return (T)Double.valueOf(this.getDouble("./" + name + "/text()", (Double)fallback));
        }
        if (fallback instanceof Integer) {
            return (T)Integer.valueOf(this.getInt("./" + name + "/text()", (Integer)fallback));
        }
        if (fallback instanceof Boolean) {
            return (T)Boolean.valueOf(this.getBoolean("./" + name + "/text()", (Boolean)fallback));
        }
        if (fallback instanceof Float) {
            return (T)Float.valueOf(this.getFloat("./" + name + "/text()", ((Float)fallback).floatValue()));
        }
        if (fallback instanceof Long) {
            return (T)Long.valueOf(this.getLong("./" + name + "/text()", (Long)fallback));
        }
        if (fallback instanceof Short) {
            return (T)Short.valueOf(this.getShort("./" + name + "/text()", (Short)fallback));
        }
        if (fallback instanceof String) {
            return (T)this.getString("./" + name + "/text()", (String)fallback);
        }
        if (fallback instanceof Enum) {
            String value = this.getString("./" + name + "/text()");
            for (Object o : fallback.getClass().getEnumConstants()) {
                if (!o.toString().equals(value)) continue;
                return (T)o;
            }
        }
        System.out.println("Unhandled type: " + fallback.getClass());
        return fallback;
    }
}

