/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.cavilog;

import dk.cavi.cavilog.LoggerI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class CAVILog {
    private static final List<LoggerI> LOGGERS = new ArrayList<LoggerI>();

    public static synchronized void addLogger(LoggerI logger) {
        LOGGERS.add(logger);
    }

    private static void logSimpleInternalArray(String text, Level level, Throwable throwable, Object[] args) {
        if (text == null) {
            text = "null";
        }
        StringBuilder sb = new StringBuilder(text);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String searchString = "{" + i + "}";
                int index = sb.indexOf(searchString);
                sb.replace(index, index + searchString.length(), args[i].toString());
            }
        }
        try {
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException ex) {
            CAVILog.log("CAVI", level, text, System.currentTimeMillis(), ex.getStackTrace()[2].getClassName(), ex.getStackTrace()[2].getMethodName(), ex.getStackTrace()[2].getLineNumber(), throwable);
            return;
        }
    }

    public static synchronized void logSimple(String text, Level level, Throwable throwable, Object ... args) {
        CAVILog.logSimpleInternalArray(text, level, throwable, args);
    }

    public static synchronized void logSimpleInfo(String text, Object ... args) {
        CAVILog.logSimpleInternalArray(text, Level.INFO, null, args);
    }

    public static synchronized void logSimpleWarning(String text, Throwable throwable, Object ... args) {
        CAVILog.logSimpleInternalArray(text, Level.WARNING, throwable, args);
    }

    public static synchronized void logSimpleSevere(String text, Throwable throwable, Object ... args) {
        CAVILog.logSimpleInternalArray(text, Level.SEVERE, throwable, args);
    }

    public static synchronized void log(String identifier, Level level, String message, long timestamp, String classname, String methodname, int lineNumber, Throwable throwable) {
        for (LoggerI logger : LOGGERS) {
            try {
                logger.log(identifier, level, message, timestamp, classname, methodname, lineNumber, throwable);
            }
            catch (Throwable e) {
                System.out.println("Error during logging");
                e.printStackTrace();
            }
        }
    }
}

