/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.cavilog;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import org.apache.commons.text.StringEscapeUtils;

public class LogFormatter {
    private LogFormatter() {
    }

    public static void printFormattedHtml(String identifier, Level level, String message, long timestamp, String classname, String methodname, int lineNumber, Throwable throwable, PrintWriter writer) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        Date date = cal.getTime();
        SimpleDateFormat df = new SimpleDateFormat();
        String escapedMessage = StringEscapeUtils.escapeHtml4((String)message).replaceAll("\n", "<br />\n");
        writer.println("<div class=\"logentry " + level.toString().toLowerCase() + "\">");
        writer.println("<p>" + df.format(date) + " " + level + " : " + classname + " " + methodname + " [line: " + lineNumber + "]</p>");
        writer.println("<div>");
        writer.println("<p>" + escapedMessage + "</p>");
        if (throwable != null) {
            writer.println("<pre>");
            throwable.printStackTrace(writer);
            writer.println("</pre>");
        }
        writer.println("</div>");
        writer.println("</div>");
    }

    public static void printFormattedText(String identifier, Level level, String message, long timestamp, String classname, String methodname, int lineNumber, Throwable throwable, PrintWriter writer) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        Date date = cal.getTime();
        SimpleDateFormat df = new SimpleDateFormat();
        writer.println(df.format(date) + " " + classname + " " + methodname + " [line: " + lineNumber + "]");
        writer.println(level + ": " + message);
        if (throwable != null) {
            throwable.printStackTrace(writer);
        }
    }
}

