/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.screensender;

import dk.cavi.cavilog.CAVILog;
import dk.cavi.eventbus.editor.DialogPanelUtils;
import dk.cavi.screensender.GrabbedInfo;
import dk.cavi.screensender.Sender;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.Executors;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import net.coobird.thumbnailator.Thumbnails;

public class ConfirmationPanel
extends JPanel {
    private final GrabbedInfo info;
    private boolean creativeChoiceMade;
    private boolean stressChoiceMade;
    private JButton cancelButton;
    private JRadioButton creativeEight;
    private JRadioButton creativeFive;
    private JRadioButton creativeFour;
    private ButtonGroup creativeGroup;
    private JRadioButton creativeNine;
    private JRadioButton creativeOne;
    private JRadioButton creativeSeven;
    private JRadioButton creativeSix;
    private JRadioButton creativeThree;
    private JRadioButton creativeTwo;
    private JPanel creativenessPanel;
    private JLabel imageLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JSeparator jSeparator1;
    private JRadioButton stressEight;
    private JRadioButton stressFive;
    private JRadioButton stressFour;
    private JRadioButton stressNine;
    private JRadioButton stressOne;
    private JPanel stressPanel;
    private JRadioButton stressSeven;
    private JRadioButton stressSix;
    private JRadioButton stressThree;
    private JRadioButton stressTwo;
    private ButtonGroup stressedGroup;

    public ConfirmationPanel(GrabbedInfo info) {
        JRadioButton radio;
        this.info = info;
        this.initComponents();
        this.creativeChoiceMade = false;
        this.stressChoiceMade = false;
        this.creativeOne.setActionCommand("1");
        this.creativeTwo.setActionCommand("2");
        this.creativeThree.setActionCommand("3");
        this.creativeFour.setActionCommand("4");
        this.creativeFive.setActionCommand("5");
        this.creativeSix.setActionCommand("6");
        this.creativeSeven.setActionCommand("7");
        this.creativeEight.setActionCommand("8");
        this.creativeNine.setActionCommand("9");
        this.stressOne.setActionCommand("1");
        this.stressTwo.setActionCommand("2");
        this.stressThree.setActionCommand("3");
        this.stressFour.setActionCommand("4");
        this.stressFive.setActionCommand("5");
        this.stressSix.setActionCommand("6");
        this.stressSeven.setActionCommand("7");
        this.stressEight.setActionCommand("8");
        this.stressNine.setActionCommand("9");
        for (Component c : this.creativenessPanel.getComponents()) {
            if (!(c instanceof JRadioButton)) continue;
            radio = (JRadioButton)c;
            radio.addActionListener(evt -> {
                this.creativeChoiceMade = true;
                this.checkSubmission();
            });
        }
        for (Component c : this.stressPanel.getComponents()) {
            if (!(c instanceof JRadioButton)) continue;
            radio = (JRadioButton)c;
            radio.addActionListener(evt -> {
                this.stressChoiceMade = true;
                this.checkSubmission();
            });
        }
        try {
            ImageIcon icon = new ImageIcon(Thumbnails.of((BufferedImage[])new BufferedImage[]{info.getScreenshot()}).size(640, 480).asBufferedImage());
            this.imageLabel.setIcon(icon);
            this.imageLabel.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
        catch (IOException ex) {
            CAVILog.logSimpleWarning((String)"Error loading screenshot as icon", (Throwable)ex, (Object[])new Object[0]);
        }
    }

    private void initComponents() {
        this.creativeGroup = new ButtonGroup();
        this.stressedGroup = new ButtonGroup();
        this.imageLabel = new JLabel();
        this.cancelButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.creativenessPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.creativeOne = new JRadioButton();
        this.creativeTwo = new JRadioButton();
        this.creativeThree = new JRadioButton();
        this.creativeFour = new JRadioButton();
        this.creativeFive = new JRadioButton();
        this.creativeSix = new JRadioButton();
        this.creativeSeven = new JRadioButton();
        this.creativeEight = new JRadioButton();
        this.creativeNine = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.stressPanel = new JPanel();
        this.jLabel8 = new JLabel();
        this.stressOne = new JRadioButton();
        this.stressTwo = new JRadioButton();
        this.stressThree = new JRadioButton();
        this.stressFour = new JRadioButton();
        this.stressFive = new JRadioButton();
        this.stressSix = new JRadioButton();
        this.stressSeven = new JRadioButton();
        this.stressEight = new JRadioButton();
        this.stressNine = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel6 = new JLabel();
        this.imageLabel.setMinimumSize(new Dimension(640, 20));
        this.imageLabel.setPreferredSize(new Dimension(640, 20));
        this.cancelButton.setText("Not now");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfirmationPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText("<html>How <b>creative</b> are you feeling right now?");
        this.jLabel3.setText("<html>How <b>stressed</b> are you feeling right now?");
        this.creativenessPanel.setLayout(new GridBagLayout());
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("<html><center>Not<br/>at all</center>");
        this.jLabel4.setHorizontalTextPosition(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.creativenessPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.creativeGroup.add(this.creativeOne);
        this.creativeOne.setText("1");
        this.creativeOne.setHorizontalAlignment(0);
        this.creativeOne.setHorizontalTextPosition(0);
        this.creativeOne.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.creativenessPanel.add((Component)this.creativeOne, gridBagConstraints);
        this.creativeGroup.add(this.creativeTwo);
        this.creativeTwo.setText("2");
        this.creativeTwo.setHorizontalAlignment(0);
        this.creativeTwo.setHorizontalTextPosition(0);
        this.creativeTwo.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.creativenessPanel.add((Component)this.creativeTwo, gridBagConstraints);
        this.creativeGroup.add(this.creativeThree);
        this.creativeThree.setText("3");
        this.creativeThree.setHorizontalAlignment(0);
        this.creativeThree.setHorizontalTextPosition(0);
        this.creativeThree.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.creativenessPanel.add((Component)this.creativeThree, gridBagConstraints);
        this.creativeGroup.add(this.creativeFour);
        this.creativeFour.setText("4");
        this.creativeFour.setHorizontalAlignment(0);
        this.creativeFour.setHorizontalTextPosition(0);
        this.creativeFour.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.creativenessPanel.add((Component)this.creativeFour, gridBagConstraints);
        this.creativeGroup.add(this.creativeFive);
        this.creativeFive.setText("5");
        this.creativeFive.setHorizontalAlignment(0);
        this.creativeFive.setHorizontalTextPosition(0);
        this.creativeFive.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.creativenessPanel.add((Component)this.creativeFive, gridBagConstraints);
        this.creativeGroup.add(this.creativeSix);
        this.creativeSix.setText("6");
        this.creativeSix.setHorizontalAlignment(0);
        this.creativeSix.setHorizontalTextPosition(0);
        this.creativeSix.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.creativenessPanel.add((Component)this.creativeSix, gridBagConstraints);
        this.creativeGroup.add(this.creativeSeven);
        this.creativeSeven.setText("7");
        this.creativeSeven.setHorizontalAlignment(0);
        this.creativeSeven.setHorizontalTextPosition(0);
        this.creativeSeven.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.creativenessPanel.add((Component)this.creativeSeven, gridBagConstraints);
        this.creativeGroup.add(this.creativeEight);
        this.creativeEight.setText("8");
        this.creativeEight.setHorizontalAlignment(0);
        this.creativeEight.setHorizontalTextPosition(0);
        this.creativeEight.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.creativenessPanel.add((Component)this.creativeEight, gridBagConstraints);
        this.creativeGroup.add(this.creativeNine);
        this.creativeNine.setText("9");
        this.creativeNine.setHorizontalAlignment(0);
        this.creativeNine.setHorizontalTextPosition(0);
        this.creativeNine.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.creativenessPanel.add((Component)this.creativeNine, gridBagConstraints);
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("<html><center>Extremely<br/>Creative</center>");
        this.jLabel5.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.creativenessPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.stressPanel.setLayout(new GridBagLayout());
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setText("<html><center>Not<br/>at all</center>");
        this.jLabel8.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.stressPanel.add((Component)this.jLabel8, gridBagConstraints);
        this.stressedGroup.add(this.stressOne);
        this.stressOne.setText("1");
        this.stressOne.setHorizontalAlignment(0);
        this.stressOne.setHorizontalTextPosition(0);
        this.stressOne.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.stressPanel.add((Component)this.stressOne, gridBagConstraints);
        this.stressedGroup.add(this.stressTwo);
        this.stressTwo.setText("2");
        this.stressTwo.setHorizontalAlignment(0);
        this.stressTwo.setHorizontalTextPosition(0);
        this.stressTwo.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.stressPanel.add((Component)this.stressTwo, gridBagConstraints);
        this.stressedGroup.add(this.stressThree);
        this.stressThree.setText("3");
        this.stressThree.setHorizontalAlignment(0);
        this.stressThree.setHorizontalTextPosition(0);
        this.stressThree.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.stressPanel.add((Component)this.stressThree, gridBagConstraints);
        this.stressedGroup.add(this.stressFour);
        this.stressFour.setText("4");
        this.stressFour.setHorizontalAlignment(0);
        this.stressFour.setHorizontalTextPosition(0);
        this.stressFour.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.stressPanel.add((Component)this.stressFour, gridBagConstraints);
        this.stressedGroup.add(this.stressFive);
        this.stressFive.setText("5");
        this.stressFive.setHorizontalAlignment(0);
        this.stressFive.setHorizontalTextPosition(0);
        this.stressFive.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.stressPanel.add((Component)this.stressFive, gridBagConstraints);
        this.stressedGroup.add(this.stressSix);
        this.stressSix.setText("6");
        this.stressSix.setHorizontalAlignment(0);
        this.stressSix.setHorizontalTextPosition(0);
        this.stressSix.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.stressPanel.add((Component)this.stressSix, gridBagConstraints);
        this.stressedGroup.add(this.stressSeven);
        this.stressSeven.setText("7");
        this.stressSeven.setHorizontalAlignment(0);
        this.stressSeven.setHorizontalTextPosition(0);
        this.stressSeven.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.stressPanel.add((Component)this.stressSeven, gridBagConstraints);
        this.stressedGroup.add(this.stressEight);
        this.stressEight.setText("8");
        this.stressEight.setHorizontalAlignment(0);
        this.stressEight.setHorizontalTextPosition(0);
        this.stressEight.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.stressPanel.add((Component)this.stressEight, gridBagConstraints);
        this.stressedGroup.add(this.stressNine);
        this.stressNine.setText("9");
        this.stressNine.setHorizontalAlignment(0);
        this.stressNine.setHorizontalTextPosition(0);
        this.stressNine.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.stressPanel.add((Component)this.stressNine, gridBagConstraints);
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("<html><center>Extremely<br/>Stressed</center>");
        this.jLabel7.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        this.stressPanel.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel6.setText("(Skip questions and delete screenshot)");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel3, -2, -1, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.creativenessPanel, -1, -1, Short.MAX_VALUE).addComponent(this.stressPanel, -1, -1, Short.MAX_VALUE)))).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.imageLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.imageLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.creativenessPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stressPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.jLabel6)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        DialogPanelUtils.closeArgumentPanel((JPanel)this);
    }

    private void checkSubmission() {
        if (this.creativeChoiceMade && this.stressChoiceMade) {
            this.sendInfo();
        }
    }

    private void sendInfo() {
        Executors.newSingleThreadExecutor().execute(() -> {
            int creativeResponse = -1;
            try {
                creativeResponse = Integer.parseInt(this.creativeGroup.getSelection().getActionCommand());
            }
            catch (Exception exception) {
                // empty catch block
            }
            int stressResponse = -1;
            try {
                stressResponse = Integer.parseInt(this.stressedGroup.getSelection().getActionCommand());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.info.setCreativeResponse(creativeResponse);
            this.info.setStressResponse(stressResponse);
            try {
                long start = System.currentTimeMillis();
                if (Sender.checkApiVersion()) {
                    CAVILog.logSimpleInfo((String)("checkApiVersion: " + (System.currentTimeMillis() - start) + "ms"), (Object[])new Object[0]);
                    start = System.currentTimeMillis();
                    Sender.sendGrabberInfo(this.info);
                    CAVILog.logSimpleInfo((String)("sendGrabberInfo: " + (System.currentTimeMillis() - start) + "ms"), (Object[])new Object[0]);
                }
            }
            catch (IOException ex) {
                CAVILog.logSimpleWarning((String)"Error sending info", (Throwable)ex, (Object[])new Object[0]);
            }
        });
        DialogPanelUtils.closeArgumentPanel((JPanel)this);
    }
}

