/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.screensender;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dk.cavi.cavilog.CAVILog;
import dk.cavi.screensender.GrabbedInfo;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class Sender {
    private static final String URL = "https://screensender.projects.cavi.au.dk/collector.php";
    private static final String VERSION = "2019.11.4378";
    private static final PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();

    public static void sendGrabberInfo(GrabbedInfo info) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)info.getScreenshot(), "png", bout);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        JsonObject json = new JsonObject();
        JsonArray processNames = new JsonArray();
        json.add("processes", (JsonElement)processNames);
        info.getProcessNames().forEach(processName -> processNames.add(processName));
        json.addProperty("stressResponse", (Number)info.getStressResponse());
        json.addProperty("creativeResponse", (Number)info.getCreativeResponse());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody("cmd", "store");
        builder.addTextBody("system", info.getUuid());
        builder.addBinaryBody("screenshot", (InputStream)bin);
        builder.addTextBody("json", json.toString());
        Sender.doSend(builder.build());
    }

    public static boolean checkApiVersion() throws IOException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody("cmd", "api-version");
        String version = Sender.doSend(builder.build());
        return version.equals(VERSION);
    }

    private static String doSend(HttpEntity entity) throws IOException {
        String responseString;
        long start = System.currentTimeMillis();
        CloseableHttpClient client = HttpClientBuilder.create().setConnectionManager(connectionManager).build();
        HttpPost post = new HttpPost(URL);
        post.setEntity(entity);
        try (CloseableHttpResponse response = client.execute(post);){
            HttpEntity responseEntity = response.getEntity();
            responseString = IOUtils.toString((InputStream)responseEntity.getContent(), (Charset)Charset.forName("UTF-8"));
        }
        CAVILog.logSimpleInfo((String)("Send took: " + (System.currentTimeMillis() - start) + "ms"), (Object[])new Object[0]);
        return responseString;
    }
}

