/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.screensender;

import dk.cavi.cavilog.CAVILog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Consumer;

public class SinkStreams
implements Runnable {
    private final InputStream in;
    private boolean doneReading;
    private final Consumer<String> consumer;

    private SinkStreams(InputStream in, Consumer<String> consumer) {
        this.in = in;
        this.consumer = consumer;
        this.doneReading = false;
        new Thread(this).start();
    }

    public static SinkStreams eatStream(InputStream in, Consumer<String> consumer) {
        return new SinkStreams(in, consumer);
    }

    @Override
    public void run() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
            String line = reader.readLine();
            while (line != null) {
                this.consumer.accept(line);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            CAVILog.logSimpleSevere((String)"Error", (Throwable)ex, (Object[])new Object[0]);
        }
        this.doneReading = true;
    }

    public boolean isDoneReading() {
        return this.doneReading;
    }

    public void waitFor(int timeout) {
        long start = System.currentTimeMillis();
        try {
            while (!this.isDoneReading()) {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - start <= (long)timeout) continue;
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

