/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.screensender;

import dk.cavi.cavilog.CAVILog;
import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class TrayHandler
implements ActionListener {
    public static boolean traySupported = true;
    private TrayIcon trayIcon = null;

    public TrayHandler() {
        this.setupTrayIcon();
    }

    private void setupTrayIcon() {
        if (!SystemTray.isSupported()) {
            traySupported = false;
        } else {
            traySupported = true;
            SystemTray tray = SystemTray.getSystemTray();
            PopupMenu popup = new PopupMenu();
            MenuItem i = new MenuItem("About");
            i.setActionCommand("about");
            i.addActionListener(this);
            popup.add(i);
            popup.addSeparator();
            i = new MenuItem("Exit");
            i.setActionCommand("exit");
            i.addActionListener(this);
            popup.add(i);
            try {
                BufferedImage image1 = ImageIO.read(this.getClass().getResourceAsStream("/images/16x16.png"));
                this.trayIcon = new TrayIcon(image1, "DesktopESM", popup);
                this.trayIcon.setImageAutoSize(false);
                this.trayIcon.addActionListener(this);
                tray.add(this.trayIcon);
            }
            catch (AWTException | IOException ex) {
                CAVILog.logSimpleWarning((String)"Error adding tray icon", (Throwable)ex, (Object[])new Object[0]);
            }
        }
    }

    public void displayMessage(String caption, String message) {
        this.trayIcon.displayMessage(caption, message, TrayIcon.MessageType.INFO);
    }

    public void setCaption(String caption) {
        this.trayIcon.setToolTip(caption);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() != null && !e.getActionCommand().equals("about") && e.getActionCommand().equals("exit")) {
            this.onShutdown();
        }
    }

    public void onShutdown() {
        if (traySupported) {
            SystemTray tray = SystemTray.getSystemTray();
            tray.remove(this.trayIcon);
            System.exit(0);
        }
    }
}

