/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.core.marshalling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import dk.cavi.eventbus.core.events.EventInterface;
import dk.cavi.eventbus.core.marshalling.EventInterfaceTypeAdapterFactory;
import dk.cavi.eventbus.core.marshalling.NumberTypeAdapterFactory;
import java.lang.reflect.Type;
import java.util.Arrays;

public class EventMarshaller {
    private final GsonBuilder factory = new GsonBuilder();
    private static EventMarshaller singleton;
    private Gson marshaller;

    private EventMarshaller() {
        this.factory.registerTypeAdapterFactory((TypeAdapterFactory)new NumberTypeAdapterFactory());
        this.factory.registerTypeAdapterFactory((TypeAdapterFactory)new EventInterfaceTypeAdapterFactory());
        this.factory.serializeNulls();
        this.marshaller = this.factory.create();
    }

    public static synchronized EventMarshaller getSingleton() {
        if (singleton == null) {
            singleton = new EventMarshaller();
        }
        return singleton;
    }

    public JsonObject marshall(EventInterface event) {
        return (JsonObject)this.marshaller.toJsonTree((Object)event);
    }

    public EventInterface unMarshall(JsonObject element) {
        return (EventInterface)this.marshaller.fromJson((JsonElement)element, EventInterface.class);
    }

    public void registerCustomMarshalling(Class marshallableEventType, TypeAdapter customMarshaller) {
        this.factory.registerTypeAdapter((Type)marshallableEventType, (Object)customMarshaller);
        this.marshaller = this.factory.create();
    }

    public Object getInternalTypedValue(JsonElement value) {
        if (value.isJsonPrimitive()) {
            JsonPrimitive primitiveType = value.getAsJsonPrimitive();
            if (primitiveType.isString()) {
                return value.getAsString();
            }
            if (primitiveType.isBoolean()) {
                return value.getAsBoolean();
            }
            throw new IllegalArgumentException("Got weird element " + value + " that shouldn't be here, was the JsonElement not internally packed properly?");
        }
        if (EventMarshaller.isInternalTypeValueObject(value)) {
            try {
                return this.marshaller.fromJson(value, Number.class);
            }
            catch (Throwable ex) {
                System.err.println("FIXME: " + this.getClass().getCanonicalName() + " error handling type " + value.getAsJsonObject().get("type") + " for " + value);
                ex.printStackTrace();
                return null;
            }
        }
        if (value.isJsonObject()) {
            return value.getAsJsonObject();
        }
        if (value.isJsonArray()) {
            return value.getAsJsonArray();
        }
        System.err.println("FIXME: " + this.getClass().getCanonicalName() + " unknown value " + value);
        throw new IllegalStateException("Not implemented yet: " + value + " - " + value.getClass());
    }

    public static boolean isSpecialField(String fieldName) {
        return fieldName.equals("identifier") || fieldName.equals("_eventbusClass");
    }

    public static boolean isInternalTypeValueObject(JsonElement internalJSON) {
        if (!internalJSON.isJsonObject()) {
            return false;
        }
        if (!internalJSON.getAsJsonObject().has("type")) {
            return false;
        }
        if (!internalJSON.getAsJsonObject().has("value")) {
            return false;
        }
        return Arrays.asList("Float", "Double", "Integer", "Byte", "Short", "Long").contains(internalJSON.getAsJsonObject().getAsJsonPrimitive("type").getAsString());
    }
}

