/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.core.serialization;

import dk.cavi.eventbus.core.serialization.Serializer;
import java.io.NotSerializableException;
import java.nio.ByteBuffer;
import org.nustaq.serialization.FSTConfiguration;

public class FSTSerializer
implements Serializer {
    protected final FSTConfiguration serializer;

    public FSTSerializer() {
        this(FSTConfiguration.createDefaultConfiguration());
    }

    public FSTSerializer(FSTConfiguration conf) {
        this.serializer = conf;
    }

    @Override
    public String getFriendlyName() {
        return "FST (Default)";
    }

    @Override
    public byte[] toByteArray(Object theObject) {
        return this.serializer.asByteArray(theObject);
    }

    @Override
    public int toByteBuffer(Object theObject, ByteBuffer targetBuffer) throws NotSerializableException {
        byte[] data = this.toByteArray(theObject);
        targetBuffer.put(data, 0, data.length);
        return data.length;
    }

    @Override
    public <T> T toObject(byte[] objByteArray) {
        return (T)this.serializer.asObject(objByteArray);
    }

    @Override
    public <T> T toObject(ByteBuffer objBuffer, int objSize) {
        byte[] objArray = new byte[objSize];
        objBuffer.get(objArray);
        return this.toObject(objArray);
    }
}

