/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.cavilog;

import dk.cavi.cavilog.LogFormatter;
import dk.cavi.cavilog.LoggerI;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HTMLFileLogger
implements LoggerI {
    private final String filename;

    public HTMLFileLogger(String filename) {
        this.filename = filename;
    }

    @Override
    public void log(String identifier, Level level, String message, long timestamp, String classname, String methodname, int lineNumber, Throwable throwable) {
        new File(this.filename).getParentFile().mkdirs();
        try (PrintWriter writer = new PrintWriter(new FileWriter(this.filename, true));){
            LogFormatter.printFormattedHtml(identifier, level, message, timestamp, classname, methodname, lineNumber, throwable, writer);
        }
        catch (IOException ex) {
            Logger.getLogger(HTMLFileLogger.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

