/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.screensender;

import dk.cavi.cavilog.CAVILog;
import java.time.LocalTime;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Randomizer {
    private final ScheduledExecutorService scheduler;
    private final Random rand;
    private final TimeUnit timeUnit;
    private final Runnable job;
    private final int minDelay;
    private final int maxDelay;
    private final LocalTime startTime;
    private final LocalTime endTime;

    public Randomizer(LocalTime startTime, LocalTime endTime, int minDelay, int maxDelay, TimeUnit timeUnit, Runnable job) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        this.timeUnit = timeUnit;
        this.job = job;
        this.scheduler = Executors.newScheduledThreadPool(2);
        this.rand = new Random();
        this.scheduleJob();
    }

    private void scheduleJob() {
        CAVILog.logSimpleInfo((String)("Start time: " + this.startTime), (Object[])new Object[0]);
        CAVILog.logSimpleInfo((String)("End time: " + this.endTime), (Object[])new Object[0]);
        LocalTime now = LocalTime.now();
        CAVILog.logSimpleInfo((String)("Now: " + now), (Object[])new Object[0]);
        boolean scheduledSomething = false;
        if (now.isAfter(this.startTime) && now.isBefore(this.endTime)) {
            long timeUntilEnd = now.until(this.endTime, this.timeUnit.toChronoUnit());
            CAVILog.logSimpleInfo((String)("timeUntilEnd: " + timeUntilEnd), (Object[])new Object[0]);
            CAVILog.logSimpleInfo((String)("minDelay: " + this.minDelay), (Object[])new Object[0]);
            if (timeUntilEnd >= (long)this.minDelay) {
                CAVILog.logSimpleInfo((String)"We are within our run period!", (Object[])new Object[0]);
                int waitTime = (int)Math.min((long)(this.rand.nextInt(this.maxDelay - this.minDelay) + this.minDelay), timeUntilEnd);
                CAVILog.logSimpleInfo((String)("Scheduling job in " + waitTime + " " + this.timeUnit.name()), (Object[])new Object[0]);
                ScheduledFuture<?> future = this.scheduler.schedule(this.job, (long)waitTime, this.timeUnit);
                scheduledSomething = true;
                try {
                    future.get();
                }
                catch (Exception e) {
                    CAVILog.logSimpleWarning((String)"Error waiting for scheduled job", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }
        if (!scheduledSomething) {
            CAVILog.logSimpleInfo((String)"Nothing scheduled, waiting 1 minute...", (Object[])new Object[0]);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException ex) {
                CAVILog.logSimpleWarning((String)"Error sleeping", (Throwable)ex, (Object[])new Object[0]);
            }
        }
        this.scheduler.execute(() -> this.scheduleJob());
    }
}

