/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class XMLSaver {
    private StringBuilder xml = new StringBuilder();
    private String indent = "";

    public static String escape(String s) {
        String result = s;
        result = result.replace("&", "&amp;");
        result = result.replace("\"", "&quot;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        result = result.replace("'", "&apos;");
        return result;
    }

    public XMLSaver() {
        this.xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
    }

    public void appendln(String s) {
        this.xml.append(this.indent).append(s).append("\n");
    }

    public void increaseIndent() {
        this.indent = this.indent + "\t";
    }

    public void decreaseIndent() {
        this.indent = this.indent.substring(0, this.indent.length() - 1);
    }

    public String getXML() {
        return this.xml.toString();
    }

    public void writeFile(String filePath) {
        this.writeFile(new File(filePath));
    }

    public void writeFile(File xmlFile) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile, false), "UTF-8");){
            writer.write(this.xml.toString());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void appendVariable(Object var, String name) {
        this.appendln("<" + name + ">" + XMLSaver.escape(var.toString()) + "</" + name + ">");
    }
}

