/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.CachedExpr;
import com.ximpleware.Expr;
import com.ximpleware.FastIntBuffer;
import com.ximpleware.NavException;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;

public class BinaryExpr
extends Expr {
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MULT = 2;
    public static final int DIV = 3;
    public static final int MOD = 4;
    public static final int OR = 5;
    public static final int AND = 6;
    public static final int EQ = 7;
    public static final int NE = 8;
    public static final int LE = 9;
    public static final int GE = 10;
    public static final int LT = 11;
    public static final int GT = 12;
    public static final byte NS_NS = 0;
    public static final byte NS_N = 1;
    public static final byte NS_S = 2;
    public static final byte NS_B = 3;
    public static final byte N_NS = 4;
    public static final byte N_N = 5;
    public static final byte N_S = 6;
    public static final byte N_B = 7;
    public static final byte S_NS = 8;
    public static final byte S_N = 9;
    public static final byte S_S = 10;
    public static final byte S_B = 11;
    public static final byte B_NS = 12;
    public static final byte B_N = 13;
    public static final byte B_S = 14;
    public static final byte B_B = 15;
    public static final int BUF_SZ_EXP = 7;
    protected int op;
    boolean isNumerical;
    boolean isBoolean;
    protected Expr left;
    protected Expr right;
    protected FastIntBuffer fib1;
    protected byte compType;

    public BinaryExpr(Expr expr, int n, Expr expr2) {
        this.op = n;
        this.left = expr;
        this.right = expr2;
        this.fib1 = null;
        switch (this.op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.isNumerical = true;
                this.isBoolean = false;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.isNumerical = false;
                this.isBoolean = true;
            }
        }
        this.compType = this.computeCompType();
    }

    public final byte computeCompType() {
        if (this.left.isNodeSet()) {
            if (this.right.isNodeSet()) {
                return 0;
            }
            if (this.right.isNumerical()) {
                return 1;
            }
            if (this.right.isString()) {
                return 2;
            }
            return 3;
        }
        if (this.left.isNumerical()) {
            if (this.right.isNodeSet()) {
                return 4;
            }
            if (this.right.isNumerical()) {
                return 5;
            }
            if (this.right.isString()) {
                return 6;
            }
            return 7;
        }
        if (this.left.isString()) {
            if (this.right.isNodeSet()) {
                return 8;
            }
            if (this.right.isNumerical()) {
                return 9;
            }
            if (this.right.isString()) {
                return 10;
            }
            return 11;
        }
        if (this.right.isNodeSet()) {
            return 12;
        }
        if (this.right.isNumerical()) {
            return 13;
        }
        if (this.right.isString()) {
            return 14;
        }
        return 15;
    }

    @Override
    public final String toString() {
        String string;
        switch (this.op) {
            case 0: {
                string = " + ";
                break;
            }
            case 1: {
                string = " - ";
                break;
            }
            case 2: {
                string = " * ";
                break;
            }
            case 3: {
                string = " / ";
                break;
            }
            case 4: {
                string = " mod ";
                break;
            }
            case 5: {
                string = " or ";
                break;
            }
            case 6: {
                string = " and ";
                break;
            }
            case 7: {
                string = " = ";
                break;
            }
            case 8: {
                string = " != ";
                break;
            }
            case 9: {
                string = " <= ";
                break;
            }
            case 10: {
                string = " >= ";
                break;
            }
            case 11: {
                string = " < ";
                break;
            }
            default: {
                string = " > ";
            }
        }
        return "(" + this.left + string + this.right + ")";
    }

    @Override
    public final boolean evalBoolean(VTDNav vTDNav) {
        switch (this.op) {
            case 5: {
                return this.left.evalBoolean(vTDNav) || this.right.evalBoolean(vTDNav);
            }
            case 6: {
                return this.left.evalBoolean(vTDNav) && this.right.evalBoolean(vTDNav);
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this.computeComp(this.op, vTDNav);
            }
        }
        double d = this.evalNumber(vTDNav);
        return d != -0.0 && d != 0.0 && !Double.isNaN(d);
    }

    @Override
    public final double evalNumber(VTDNav vTDNav) {
        switch (this.op) {
            case 0: {
                return this.left.evalNumber(vTDNav) + this.right.evalNumber(vTDNav);
            }
            case 1: {
                return this.left.evalNumber(vTDNav) - this.right.evalNumber(vTDNav);
            }
            case 2: {
                return this.left.evalNumber(vTDNav) * this.right.evalNumber(vTDNav);
            }
            case 3: {
                return this.left.evalNumber(vTDNav) / this.right.evalNumber(vTDNav);
            }
            case 4: {
                return this.left.evalNumber(vTDNav) % this.right.evalNumber(vTDNav);
            }
        }
        if (this.evalBoolean(vTDNav)) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public final int evalNodeSet(VTDNav vTDNav) throws XPathEvalException {
        throw new XPathEvalException("BinaryExpr can't eval to a node set!");
    }

    @Override
    public final String evalString(VTDNav vTDNav) {
        if (this.isNumerical()) {
            double d = this.evalNumber(vTDNav);
            if (d == (double)((long)d)) {
                return "" + (long)d;
            }
            return "" + d;
        }
        boolean bl = this.evalBoolean(vTDNav);
        if (bl) {
            return "true";
        }
        return "false";
    }

    @Override
    public final void reset(VTDNav vTDNav) {
        this.left.reset(vTDNav);
        this.right.reset(vTDNav);
    }

    @Override
    public final boolean isNodeSet() {
        return false;
    }

    @Override
    public final boolean isNumerical() {
        return this.isNumerical;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final boolean isBoolean() {
        return this.isBoolean;
    }

    private final boolean computeComp(int n, VTDNav vTDNav) {
        switch (this.compType) {
            case 0: {
                return this.compNodeSetNodeSet(this.left, this.right, vTDNav, n);
            }
            case 1: {
                return this.compNodeSetNumerical(this.left, this.right, vTDNav, n);
            }
            case 2: {
                if (n == 7 || n == 8) {
                    return this.compNodeSetString(this.left, this.right, vTDNav, n);
                }
                return this.compNodeSetNumerical(this.left, this.right, vTDNav, n);
            }
            case 4: {
                return this.compNumericalNodeSet(this.left, this.right, vTDNav, n);
            }
            case 8: {
                if (n == 7 || n == 8) {
                    return this.compStringNodeSet(this.left, this.right, vTDNav, n);
                }
                return this.compNumericalNodeSet(this.left, this.right, vTDNav, n);
            }
        }
        if (n == 7 || n == 8) {
            if (this.left.isBoolean() || this.right.isBoolean()) {
                if (n == 7) {
                    return this.left.evalBoolean(vTDNav) == this.right.evalBoolean(vTDNav);
                }
                return this.left.evalBoolean(vTDNav) != this.right.evalBoolean(vTDNav);
            }
            if (this.left.isNumerical() || this.right.isNumerical()) {
                if (n == 7) {
                    return this.left.evalNumber(vTDNav) == this.right.evalNumber(vTDNav);
                }
                return this.left.evalNumber(vTDNav) != this.right.evalNumber(vTDNav);
            }
            String string = this.left.evalString(vTDNav);
            String string2 = this.right.evalString(vTDNav);
            return n == 7 ? string.equals(string2) : !string.equals(string2);
        }
        return this.compNumbers(this.left.evalNumber(vTDNav), this.right.evalNumber(vTDNav), n);
    }

    @Override
    public final boolean requireContextSize() {
        return this.left.requireContextSize() || this.right.requireContextSize();
    }

    @Override
    public final void setContextSize(int n) {
        this.left.setContextSize(n);
        this.right.setContextSize(n);
    }

    @Override
    public final void setPosition(int n) {
        this.left.setPosition(n);
        this.right.setPosition(n);
    }

    private final boolean compNodeSetString(Expr expr, Expr expr2, VTDNav vTDNav, int n) {
        int n2 = 0;
        try {
            int n3;
            String string = expr2.evalString(vTDNav);
            vTDNav.push2();
            int n4 = vTDNav.contextStack2.size;
            while ((n3 = expr.evalNodeSet(vTDNav)) != -1) {
                boolean bl;
                int n5 = vTDNav.getTokenType(n3);
                if (n5 != 0 && n5 != 13) {
                    n2 = this.getStringVal(vTDNav, n3);
                    if (n2 == -1 || !(bl = this.compareVString1(n2, vTDNav, string, n))) continue;
                    expr.reset(vTDNav);
                    vTDNav.contextStack2.size = n4;
                    vTDNav.pop2();
                    return bl;
                }
                bl = vTDNav.XPathStringVal_Matches(n3, string);
                if (n == 8) {
                    boolean bl2 = bl = !bl;
                }
                if (!bl) continue;
                expr.reset(vTDNav);
                vTDNav.contextStack2.size = n4;
                vTDNav.pop2();
                return bl;
            }
            vTDNav.contextStack2.size = n4;
            vTDNav.pop2();
            expr.reset(vTDNav);
            return false;
        }
        catch (Exception exception) {
            throw new RuntimeException("Undefined behavior");
        }
    }

    private final boolean compareEmptyNodeSet(int n, String string) {
        if (n == 8) {
            return string.length() != 0;
        }
        return string.length() == 0;
    }

    private final boolean compStringNodeSet(Expr expr, Expr expr2, VTDNav vTDNav, int n) {
        int n2 = 0;
        try {
            int n3;
            String string = expr.evalString(vTDNav);
            vTDNav.push2();
            int n4 = vTDNav.contextStack2.size;
            while ((n3 = expr2.evalNodeSet(vTDNav)) != -1) {
                boolean bl;
                int n5 = vTDNav.getTokenType(n3);
                if (n5 != 0 && n5 != 13) {
                    n2 = this.getStringVal(vTDNav, n3);
                    if (n2 == -1 || !(bl = this.compareVString2(n2, vTDNav, string, n))) continue;
                    expr2.reset(vTDNav);
                    vTDNav.contextStack2.size = n4;
                    vTDNav.pop2();
                    return bl;
                }
                bl = vTDNav.XPathStringVal_Matches(n3, string);
                if (n == 8) {
                    boolean bl2 = bl = !bl;
                }
                if (!bl) continue;
                expr2.reset(vTDNav);
                vTDNav.contextStack2.size = n4;
                vTDNav.pop2();
                return bl;
            }
            vTDNav.contextStack2.size = n4;
            vTDNav.pop2();
            expr2.reset(vTDNav);
            return false;
        }
        catch (Exception exception) {
            throw new RuntimeException("Undefined behavior");
        }
    }

    private final boolean compNumbers(double d, double d2, int n) {
        switch (n) {
            case 9: {
                return d <= d2;
            }
            case 10: {
                return d >= d2;
            }
            case 11: {
                return d < d2;
            }
            case 12: {
                return d > d2;
            }
        }
        return false;
    }

    private final boolean compNumericalNodeSet(Expr expr, Expr expr2, VTDNav vTDNav, int n) {
        try {
            int n2;
            double d = expr.evalNumber(vTDNav);
            vTDNav.push2();
            int n3 = vTDNav.contextStack2.size;
            while ((n2 = expr2.evalNodeSet(vTDNav)) != -1) {
                if (!this.compareVNumber1(n2, vTDNav, d, n)) continue;
                expr2.reset(vTDNav);
                vTDNav.contextStack2.size = n3;
                vTDNav.pop2();
                return true;
            }
            vTDNav.contextStack2.size = n3;
            vTDNav.pop2();
            expr2.reset(vTDNav);
            return false;
        }
        catch (Exception exception) {
            throw new RuntimeException("Undefined behavior");
        }
    }

    private final boolean compNodeSetNumerical(Expr expr, Expr expr2, VTDNav vTDNav, int n) {
        try {
            int n2;
            double d = expr2.evalNumber(vTDNav);
            vTDNav.push2();
            int n3 = vTDNav.contextStack2.size;
            while ((n2 = expr.evalNodeSet(vTDNav)) != -1) {
                if (!this.compareVNumber2(n2, vTDNav, d, n)) continue;
                expr.reset(vTDNav);
                vTDNav.contextStack2.size = n3;
                vTDNav.pop2();
                return true;
            }
            vTDNav.contextStack2.size = n3;
            vTDNav.pop2();
            expr.reset(vTDNav);
            return false;
        }
        catch (Exception exception) {
            throw new RuntimeException("Undefined behavior");
        }
    }

    private final int getStringVal(VTDNav vTDNav, int n) {
        int n2 = vTDNav.getTokenType(n);
        if (n2 == 0) {
            int n3 = vTDNav.getText();
            return n3;
        }
        if (n2 == 2 || n2 == 3 || n2 == 7) {
            return n + 1;
        }
        return n;
    }

    private final boolean compareVNumber1(int n, VTDNav vTDNav, double d, int n2) throws NavException {
        double d2;
        int n3 = vTDNav.getTokenType(n);
        if (n3 == 0 || n3 == 13) {
            d2 = vTDNav.XPathStringVal2Double(n);
        } else {
            n = this.getStringVal(vTDNav, n);
            d2 = vTDNav.parseDouble(n);
        }
        switch (n2) {
            case 7: {
                return d == d2;
            }
            case 8: {
                return d != d2;
            }
            case 10: {
                return d >= d2;
            }
            case 9: {
                return d <= d2;
            }
            case 12: {
                return d > d2;
            }
        }
        return d < d2;
    }

    private final boolean compareVString1(int n, VTDNav vTDNav, String string, int n2) throws NavException {
        int n3 = vTDNav.compareTokenString(n, string);
        switch (n3) {
            case -1: {
                if (n2 != 8 && n2 != 11 && n2 != 9) break;
                return true;
            }
            case 0: {
                if (n2 != 7 && n2 != 9 && n2 != 10) break;
                return true;
            }
            case 1: {
                if (n2 != 8 && n2 != 10 && n2 != 12) break;
                return true;
            }
        }
        return false;
    }

    private final boolean compareVString2(int n, VTDNav vTDNav, String string, int n2) throws NavException {
        int n3 = vTDNav.compareTokenString(n, string);
        switch (n3) {
            case -1: {
                if (n2 != 8 && n2 != 12 && n2 != 10) break;
                return true;
            }
            case 0: {
                if (n2 != 7 && n2 != 9 && n2 != 10) break;
                return true;
            }
            case 1: {
                if (n2 != 8 && n2 != 9 && n2 != 11) break;
                return true;
            }
        }
        return false;
    }

    private final boolean compareVNumber2(int n, VTDNav vTDNav, double d, int n2) throws NavException {
        double d2;
        int n3 = vTDNav.getTokenType(n);
        if (n3 == 0 || n3 == 13) {
            d2 = vTDNav.XPathStringVal2Double(n);
        } else {
            n = this.getStringVal(vTDNav, n);
            d2 = vTDNav.parseDouble(n);
        }
        switch (n2) {
            case 7: {
                return d2 == d;
            }
            case 8: {
                return d2 != d;
            }
            case 10: {
                return d2 >= d;
            }
            case 9: {
                return d2 <= d;
            }
            case 12: {
                return d2 > d;
            }
        }
        return d2 < d;
    }

    private final boolean compareVV(int n, VTDNav vTDNav, int n2, int n3) throws NavException {
        int n4 = vTDNav.XPathStringVal_Matches(n, vTDNav, n2);
        switch (n4) {
            case 1: {
                if (n3 != 8 && n3 != 10 && n3 != 12) break;
                return true;
            }
            case 0: {
                if (n3 != 7 && n3 != 9 && n3 != 10) break;
                return true;
            }
            case -1: {
                if (n3 != 8 && n3 != 11 && n3 != 9) break;
                return true;
            }
        }
        return false;
    }

    private final boolean compNodeSetNodeSet(Expr expr, Expr expr2, VTDNav vTDNav, int n) {
        try {
            int n2;
            int n3;
            if (this.fib1 == null) {
                this.fib1 = new FastIntBuffer(7);
            }
            vTDNav.push2();
            int n4 = vTDNav.contextStack2.size;
            while ((n3 = expr.evalNodeSet(vTDNav)) != -1) {
                n2 = this.getStringVal(vTDNav, n3);
                if (n2 == -1) continue;
                this.fib1.append(n2);
            }
            expr.reset(vTDNav);
            vTDNav.contextStack2.size = n4;
            vTDNav.pop2();
            vTDNav.push2();
            n4 = vTDNav.contextStack2.size;
            while ((n3 = expr2.evalNodeSet(vTDNav)) != -1) {
                n2 = this.getStringVal(vTDNav, n3);
                if (n2 == -1) continue;
                int n5 = this.fib1.size;
                for (int i = 0; i < n5; ++i) {
                    boolean bl = this.compareVV(this.fib1.intAt(i), vTDNav, n2, n);
                    if (!bl) continue;
                    this.fib1.clear();
                    vTDNav.contextStack2.size = n4;
                    vTDNav.pop2();
                    expr2.reset(vTDNav);
                    return true;
                }
            }
            vTDNav.contextStack2.size = n4;
            vTDNav.pop2();
            expr2.reset(vTDNav);
            this.fib1.clear();
            return false;
        }
        catch (Exception exception) {
            this.fib1.clear();
            throw new RuntimeException("Undefined behavior");
        }
    }

    @Override
    public final int adjust(int n) {
        int n2;
        int n3 = this.left.adjust(n);
        if (n3 > (n2 = this.right.adjust(n))) {
            return n3;
        }
        return n2;
    }

    @Override
    public final boolean isFinal() {
        return this.left.isFinal() && this.right.isFinal();
    }

    @Override
    public final void markCacheable() {
        this.left.markCacheable();
        this.right.markCacheable();
    }

    @Override
    public final void markCacheable2() {
        CachedExpr cachedExpr;
        if (this.left.isFinal() && this.left.isNodeSet()) {
            cachedExpr = new CachedExpr(this.left);
            this.left = cachedExpr;
        }
        this.left.markCacheable2();
        if (this.right.isFinal() && this.right.isNodeSet()) {
            cachedExpr = new CachedExpr(this.right);
            this.right = cachedExpr;
        }
        this.right.markCacheable2();
    }

    @Override
    public final void clearCache() {
        this.left.clearCache();
        this.right.clearCache();
    }
}

