/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.core;

import dk.cavi.cavilog.CAVILog;
import dk.cavi.eventbus.core.FilterInterface;
import dk.cavi.eventbus.core.FilterInterfaceTrafficListener;
import dk.cavi.eventbus.core.annotations.AutoControlPanel;
import dk.cavi.eventbus.core.annotations.SavedParameter;
import dk.cavi.eventbus.core.events.EventInterface;
import dk.cavi.eventbus.core.ui.AutoControlPanelUI;
import dk.cavi.xml.XMLNode;
import dk.cavi.xml.XMLSaver;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.xml.xpath.XPathExpressionException;

public abstract class AbstractFilterInterface<I extends EventInterface, O extends EventInterface>
implements FilterInterface<I, O> {
    private List<FilterInterfaceTrafficListener> trafficListeners;
    private Map<String, List<FilterInterface<? super O, ?>>> outputs = new HashMap();
    protected transient boolean dirty = false;
    private boolean enabled = true;
    private boolean passthrough;
    protected JPanel controlPanel;

    public AbstractFilterInterface() {
        this.trafficListeners = new ArrayList<FilterInterfaceTrafficListener>();
        this.addOutputPin("default");
        this.setupNewFilter();
        this.setupTransients();
        this.setEnabled(this.enabled);
    }

    protected abstract void setupNewFilter();

    protected abstract void setupTransients();

    protected void sendOutput(O event) {
        this.sendOutput("default", event);
    }

    @Override
    public void setPassthrough(boolean passthrough) {
        if (this.passthrough != passthrough) {
            this.passthrough = passthrough;
            this.makeDirty();
        }
    }

    @Override
    public boolean isPassthrough() {
        return this.passthrough;
    }

    protected void sendOutput(String name, O event) {
        long latencyMeasureStart = System.nanoTime();
        if (!this.isEnabled()) {
            return;
        }
        List<FilterInterface<O, ?>> outputChain = this.outputs.get(name);
        if (outputChain == null) {
            throw new UnsupportedOperationException("Cannot send output to a non-existing output pin: " + name);
        }
        if (outputChain.size() == 1) {
            this.handleOutputChain(outputChain.get(0), (EventInterface)event, latencyMeasureStart, name);
        } else {
            outputChain.parallelStream().forEach(listener -> this.handleOutputChain((FilterInterface)listener, (EventInterface)event.makeCopy(), latencyMeasureStart, name));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleOutputChain(FilterInterface listener, EventInterface event, long latencyMeasureStart, String name) {
        try {
            if (listener.isPassthrough()) {
                if (!(listener instanceof AbstractFilterInterface)) throw new IllegalStateException("Filter has to extend AbstractFilterInterface to be passthroughed: " + listener.getClass().getSimpleName());
                AbstractFilterInterface filter = (AbstractFilterInterface)listener;
                filter.sendOutput(name, event);
            } else {
                listener.onInputEvent(event, this);
            }
            long latency = System.nanoTime() - latencyMeasureStart;
            this.trafficListeners.parallelStream().forEach(tl -> tl.onSuccess(listener, latency));
            return;
        }
        catch (ClassCastException e) {
            long latency = System.nanoTime() - latencyMeasureStart;
            this.trafficListeners.parallelStream().forEach(tl -> tl.onError(listener, latency, event));
            return;
        }
        catch (Throwable e) {
            long latency = System.nanoTime() - latencyMeasureStart;
            this.trafficListeners.parallelStream().forEach(tl -> tl.onError(listener, latency, event));
            CAVILog.logSimpleWarning((String)("Filter fail:" + e.toString()), (Throwable)e, (Object[])new Object[0]);
        }
    }

    @Override
    public final void attachOutputListener(FilterInterface<? super O, ?> listener) {
        this.attachOutputListener("default", listener);
    }

    @Override
    public final synchronized void attachOutputListener(String name, FilterInterface<? super O, ?> listener) {
        Map<String, List<FilterInterface<O, ?>>> temporaryOutputs = this.deepCloneOutputs();
        List<FilterInterface<O, ?>> outputChain = temporaryOutputs.get(name);
        if (outputChain == null) {
            throw new UnsupportedOperationException("Cannot attach a filter to a non-existing output pin: " + name);
        }
        outputChain.add(listener);
        this.makeDirty();
        this.outputs = temporaryOutputs;
    }

    @Override
    public synchronized void removeOutputListener(FilterInterface filter) {
        Map<String, List<FilterInterface<O, ?>>> temporaryOutputs = this.deepCloneOutputs();
        for (List<FilterInterface<O, ?>> filterList : temporaryOutputs.values()) {
            Iterator<FilterInterface<O, ?>> it = filterList.iterator();
            while (it.hasNext()) {
                if (it.next() != filter) continue;
                it.remove();
                this.removeAssociatedTrafficListener(filter);
                this.makeDirty();
            }
        }
        this.outputs = temporaryOutputs;
    }

    public final synchronized void addOutputPin(String name) {
        Map<String, List<FilterInterface<O, ?>>> temporaryOutputs = this.deepCloneOutputs();
        temporaryOutputs.put(name, new ArrayList());
        this.outputs = temporaryOutputs;
    }

    private Map<String, List<FilterInterface<? super O, ?>>> deepCloneOutputs() {
        HashMap newClone = new HashMap();
        for (Map.Entry<String, List<FilterInterface<O, ?>>> filterListEntry : this.outputs.entrySet()) {
            ArrayList newList = new ArrayList(filterListEntry.getValue());
            newClone.put(filterListEntry.getKey(), newList);
        }
        return newClone;
    }

    @Override
    public synchronized void clearOutputs() {
        for (List<FilterInterface<O, ?>> list : this.outputs.values()) {
            for (FilterInterface<? super O, ?> filterInterface : list) {
                this.removeOutputListener(filterInterface);
            }
        }
        ArrayList<FilterInterfaceTrafficListener> newListeners = new ArrayList<FilterInterfaceTrafficListener>();
        this.trafficListeners = newListeners;
    }

    @Override
    public Map<String, List<FilterInterface<? super O, ?>>> getOutputs() {
        return this.outputs;
    }

    @Override
    public JPanel editorControlPanel() {
        if (this.controlPanel == null) {
            Class controlPanelClass = this.findControlPanel();
            if (controlPanelClass != null) {
                try {
                    Constructor constructor = controlPanelClass.getConstructor(this.getClass());
                    this.controlPanel = (JPanel)constructor.newInstance(this);
                }
                catch (Exception ex) {
                    Logger.getLogger(AbstractFilterInterface.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else if (this.getClass().isAnnotationPresent(AutoControlPanel.class)) {
                this.controlPanel = new AutoControlPanelUI(this);
            }
        }
        return this.controlPanel;
    }

    private Class lookupControlPanel(String packageName, String baseName) throws ClassNotFoundException {
        try {
            return Class.forName(packageName + ".ui." + baseName + "ControlPanel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassNotFoundException();
        }
    }

    private Class findControlPanel() {
        String packageName = this.getClass().getPackage().getName();
        String filterName = this.getClass().getSimpleName();
        try {
            return this.lookupControlPanel(packageName, filterName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (filterName.endsWith("Filter")) {
                try {
                    return this.lookupControlPanel(packageName, filterName.substring(0, filterName.length() - 6));
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            if (filterName.contains("Filter")) {
                try {
                    return this.lookupControlPanel(packageName, filterName.replace("Filter", ""));
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    @Override
    public JPanel defaultActionPanel() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.setEnabled(false);
        Object object = this.outputs;
        synchronized (object) {
            this.outputs.clear();
        }
        object = this.trafficListeners;
        synchronized (object) {
            this.trafficListeners.clear();
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void clearDirty() {
        this.dirty = false;
    }

    @Override
    public void makeDirty() {
        this.dirty = true;
    }

    @Override
    public synchronized void addTrafficListener(FilterInterfaceTrafficListener listener) {
        ArrayList<FilterInterfaceTrafficListener> newListeners = new ArrayList<FilterInterfaceTrafficListener>(this.trafficListeners);
        newListeners.add(listener);
        this.trafficListeners = newListeners;
    }

    @Override
    public synchronized void removeTrafficListener(FilterInterfaceTrafficListener listener) {
        ArrayList<FilterInterfaceTrafficListener> newListeners = new ArrayList<FilterInterfaceTrafficListener>(this.trafficListeners);
        newListeners.remove(listener);
        this.trafficListeners = newListeners;
    }

    private synchronized void removeAssociatedTrafficListener(FilterInterface filter) {
        for (FilterInterfaceTrafficListener tl : this.trafficListeners) {
            if (!tl.isInputFilter(filter)) continue;
            this.removeTrafficListener(tl);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.makeDirty();
        }
        this.enabled = enabled;
    }

    @Override
    public void saveToXML(XMLSaver xml) {
        xml.appendln("<filter class=\"" + this.getClass().getCanonicalName() + "\" enabled=\"" + this.enabled + "\" passthrough=\"" + this.passthrough + "\">");
        xml.increaseIndent();
        System.out.println("Saving: " + this.getClass().getName());
        Arrays.stream(this.getClass().getDeclaredFields()).forEach(field -> {
            if (field.isAnnotationPresent(SavedParameter.class)) {
                SavedParameter sp = field.getAnnotation(SavedParameter.class);
                String name = sp.name();
                if (name.equals("")) {
                    name = field.getName();
                }
                String fieldName = field.getName();
                String fieldGetMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Method fieldGetMethod = this.getClass().getMethod(fieldGetMethodName, new Class[0]);
                    Object fieldValue = fieldGetMethod.invoke((Object)this, new Object[0]);
                    xml.appendVariable(fieldValue, name);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    CAVILog.logSimpleWarning((String)"Error saving field using @SavedParameter", (Throwable)ex, (Object[])new Object[0]);
                }
                catch (NoSuchMethodException | SecurityException ex) {
                    CAVILog.logSimpleWarning((String)("Unable to find field getter: " + fieldGetMethodName), (Throwable)ex, (Object[])new Object[0]);
                }
            }
        });
        this.internalSaveToXML(xml);
        xml.decreaseIndent();
        xml.appendln("</filter>");
    }

    @Override
    public void loadFromXML(XMLNode xml) {
        try {
            Arrays.stream(this.getClass().getDeclaredFields()).forEach(field -> {
                if (field.isAnnotationPresent(SavedParameter.class)) {
                    SavedParameter sp = field.getAnnotation(SavedParameter.class);
                    String name = sp.name();
                    if (name.equals("")) {
                        name = field.getName();
                    }
                    String fieldName = field.getName();
                    String fieldSetMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    String fieldGetMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    try {
                        Method fieldGetMethod = this.getClass().getMethod(fieldGetMethodName, new Class[0]);
                        Object fieldOldValue = fieldGetMethod.invoke((Object)this, new Object[0]);
                        Object fieldValue = xml.loadVariable(name, fieldOldValue);
                        Method fieldSetMethod = this.getClass().getMethod(fieldSetMethodName, field.getType());
                        fieldSetMethod.invoke((Object)this, fieldValue);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        CAVILog.logSimpleWarning((String)"Error loading field using @SavedParameter", (Throwable)ex, (Object[])new Object[0]);
                    }
                    catch (NoSuchMethodException | SecurityException ex) {
                        CAVILog.logSimpleWarning((String)("Unable to find method getter/setter: " + fieldGetMethodName + "/" + fieldSetMethodName), (Throwable)ex, (Object[])new Object[0]);
                    }
                }
            });
            this.internalLoadFromXML(xml);
            this.setEnabled(xml.getBoolean("./@enabled", true));
            this.setPassthrough(xml.getBoolean("./@passthrough", false));
            CAVILog.logSimpleInfo((String)("Loaded filter of class: " + this.getClass()), (Object[])new Object[0]);
        }
        catch (Throwable ex) {
            CAVILog.logSimpleWarning((String)"Error loading filter", (Throwable)ex, (Object[])new Object[0]);
            this.setupNewFilter();
            this.setEnabled(false);
        }
    }

    protected abstract void internalSaveToXML(XMLSaver var1);

    protected abstract void internalLoadFromXML(XMLNode var1) throws XPathExpressionException;
}

