/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.core.events;

import dk.cavi.eventbus.core.events.DataCarryingEvent;
import dk.cavi.eventbus.core.events.TransitioningEvent;
import java.awt.Color;
import java.util.Arrays;

public class PixelDataCarryingEvent
extends DataCarryingEvent
implements TransitioningEvent<PixelDataCarryingEvent> {
    public static double LINEAR_GAMMA = 2.0;
    private TransitioningEvent.TransitionType transition;
    private long transitionTime;
    private FORMAT format;

    public FORMAT getFormat() {
        return this.format;
    }

    public void setFormat(FORMAT format) {
        this.format = format;
    }

    public PixelDataCarryingEvent(String identifier, byte[] data, FORMAT format) {
        this(identifier, data, TransitioningEvent.TransitionType.SET, 0L, format);
    }

    public PixelDataCarryingEvent(String identifier, byte[] data, TransitioningEvent.TransitionType transition, long transitionTime, FORMAT format) {
        super(identifier, data);
        this.transition = transition;
        this.transitionTime = transitionTime;
        this.format = format;
    }

    public byte[] getData(FORMAT targetFormat) {
        if (targetFormat == this.format) {
            return this.data;
        }
        switch (this.format) {
            case RGB: {
                switch (targetFormat) {
                    case GRAYSCALE: {
                        byte[] luminance = new byte[this.data.length / 3];
                        for (int i = 0; i < luminance.length; ++i) {
                            luminance[i] = (byte)(((this.data[i * 3] & 0xFF) + (this.data[i * 3 + 1] & 0xFF) + (this.data[i * 3 + 2] & 0xFF)) / 3);
                        }
                        return luminance;
                    }
                    case RGBWWW: {
                        byte[] wcOut = new byte[this.data.length * 6 / 3];
                        for (int i = 0; i < this.data.length; i += 3) {
                            int index = i / 3;
                            int r = this.data[i] & 0xFF;
                            int g = this.data[i + 1] & 0xFF;
                            int b = this.data[i + 2] & 0xFF;
                            float[] hsb = new float[3];
                            Color.RGBtoHSB(r, g, b, hsb);
                            int warm = (int)(255.0f * ((1.0f - hsb[1]) * hsb[2]));
                            int white = 0;
                            int cold = 0;
                            wcOut[index * 6] = (byte)((r -= warm) & 0xFF);
                            wcOut[index * 6 + 1] = (byte)((g -= warm) & 0xFF);
                            wcOut[index * 6 + 2] = (byte)((b -= warm) & 0xFF);
                            wcOut[index * 6 + 3] = (byte)(warm & 0xFF);
                            wcOut[index * 6 + 4] = (byte)(white & 0xFF);
                            wcOut[index * 6 + 5] = (byte)(cold & 0xFF);
                        }
                        return wcOut;
                    }
                    case OSRAM_KREIOS_RGBGW: {
                        byte[] output = new byte[this.data.length * 5 / 3];
                        double LINEAR_RED = 1.0;
                        double LINEAR_GREEN = 0.75;
                        double LINEAR_BLUE = 0.413;
                        for (int i = 0; i < this.data.length; i += 3) {
                            int index = i / 3;
                            int r = this.data[i] & 0xFF;
                            int g = this.data[i + 1] & 0xFF;
                            int b = this.data[i + 2] & 0xFF;
                            double rOut = Math.pow((double)r / 255.0, 1.1395);
                            double gOut = Math.pow((double)g / 255.0, 1.353);
                            double bOut = Math.pow((double)b / 255.0, 1.34);
                            double white = Math.min((double)r / 255.0, Math.min((double)g / 255.0, (double)b / 255.0));
                            white = Math.pow(white, 1.409);
                            rOut -= white;
                            gOut -= white;
                            bOut -= white;
                            rOut = Math.max(0.0, rOut) * LINEAR_RED;
                            gOut = Math.max(0.0, gOut) * LINEAR_GREEN;
                            bOut = Math.max(0.0, bOut) * LINEAR_BLUE;
                            output[index * 5] = (byte)(rOut * 255.0);
                            output[index * 5 + 1] = (byte)(gOut * 255.0);
                            output[index * 5 + 2] = (byte)(bOut * 255.0);
                            output[index * 5 + 3] = (byte)(gOut * 255.0);
                            output[index * 5 + 4] = (byte)(white * 255.0);
                        }
                        return output;
                    }
                }
                throw new IllegalStateException("FIXME: Conversion from " + (Object)((Object)this.format) + " to " + (Object)((Object)targetFormat) + " not implemented yet");
            }
            case OSRAM_KREIOS_RGBGW: {
                switch (targetFormat) {
                    case RGB: {
                        System.out.println("Warning: Do not use OSRAM_KREIOS_RGBGW->RGB conversion it is for debugging only");
                        byte[] output = new byte[this.data.length * 3 / 5];
                        for (int i = 0; i < this.data.length; i += 5) {
                            int index = i / 5;
                            double whiteness = (double)(this.data[i + 4] & 0xFF) / 255.0;
                            double rOrig = (double)(this.data[i] & 0xFF) / 255.0;
                            double gOrig = (double)(this.data[i + 1] & 0xFF) / 255.0;
                            double bOrig = (double)(this.data[i + 2] & 0xFF) / 255.0;
                            double r = Math.min(1.0, Math.pow(rOrig * (1.0 - whiteness), 1.0 / LINEAR_GAMMA) + whiteness);
                            double g = Math.min(1.0, Math.pow(gOrig * (1.0 - whiteness), 1.0 / LINEAR_GAMMA) + whiteness);
                            double b = Math.min(1.0, Math.pow(bOrig * (1.0 - whiteness), 1.0 / LINEAR_GAMMA) + whiteness);
                            output[index * 3] = (byte)(r * 255.0);
                            output[index * 3 + 1] = (byte)(g * 255.0);
                            output[index * 3 + 2] = (byte)(b * 255.0);
                        }
                        return output;
                    }
                }
                throw new IllegalStateException("FIXME: Conversion from " + (Object)((Object)this.format) + " to " + (Object)((Object)targetFormat) + " not implemented yet");
            }
        }
        throw new IllegalStateException("FIXME: Conversion from " + (Object)((Object)this.format) + " to " + (Object)((Object)targetFormat) + " not implemented yet");
    }

    @Override
    public PixelDataCarryingEvent makeCopy() {
        return new PixelDataCarryingEvent(this.getIdentifier(), this.data, this.transition, this.transitionTime, this.format);
    }

    @Override
    public TransitioningEvent.TransitionType getTransitionType() {
        return this.transition;
    }

    @Override
    public void setTransitionType(TransitioningEvent.TransitionType transition) {
        this.transition = transition;
    }

    @Override
    public long getTransitionTime() {
        return this.transitionTime;
    }

    @Override
    public void setTransitionTime(long transitionTime) {
        this.transitionTime = transitionTime;
    }

    public String toString() {
        return "PixelDataCarryingEvent [" + (Object)((Object)this.getTransitionType()) + " - " + this.getTransitionTime() + "ms]: " + Arrays.toString(this.getData()) + " " + (Object)((Object)this.format);
    }

    @Override
    public PixelDataCarryingEvent getTransitionedCopy(PixelDataCarryingEvent target, TransitioningEvent.TransitionType type, float targetFraction) {
        switch (type) {
            case FADE: 
            case FADE_DITHER_SPATIAL: {
                byte[] ourData = this.getData();
                byte[] theirData = target.getData();
                byte[] outputData = new byte[Math.max(theirData.length, ourData.length)];
                for (int i = 0; i < Math.min(theirData.length, ourData.length); ++i) {
                    double outputValue = (1.0 - (double)targetFraction) * (double)(ourData[i] & 0xFF) + (double)(targetFraction * (float)(theirData[i] & 0xFF));
                    double dither = 0.0;
                    if (type == TransitioningEvent.TransitionType.FADE_DITHER_SPATIAL) {
                        dither = -0.2 + 0.002 * (double)(i * 6997 % 211);
                    }
                    int ditheredOutputValue = (int)Math.min(255L, Math.max(0L, Math.round(outputValue + dither)));
                    outputData[i] = (byte)ditheredOutputValue;
                }
                return new PixelDataCarryingEvent(this.getIdentifier(), outputData, this.format);
            }
        }
        return target;
    }

    public static enum FORMAT {
        GRAYSCALE(1),
        RGB(3),
        RGBA(4),
        OSRAM_KREIOS_RGBGW(5),
        RGBWWW(6),
        CUSTOM(1);

        private final int size;

        private FORMAT(int s) {
            this.size = s;
        }

        public int size() {
            return this.size;
        }
    }
}

