/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.core.marshalling;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class NumberTypeAdapter
extends TypeAdapter<Number> {
    private final String numberType;

    public NumberTypeAdapter(String type) {
        this.numberType = type;
    }

    public void write(JsonWriter out, Number value) throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("type", value.getClass().getSimpleName());
        json.addProperty("value", value);
        Streams.write((JsonElement)json, (JsonWriter)out);
    }

    public Number read(JsonReader in) throws IOException {
        Number result = null;
        JsonElement inElement = Streams.parse((JsonReader)in);
        if (inElement.isJsonObject()) {
            JsonObject jsonObject = inElement.getAsJsonObject();
            switch (jsonObject.get("type").getAsString()) {
                case "Long": {
                    result = jsonObject.get("value").getAsLong();
                    break;
                }
                case "Integer": {
                    result = jsonObject.get("value").getAsInt();
                    break;
                }
                case "Short": {
                    result = jsonObject.get("value").getAsShort();
                    break;
                }
                case "Byte": {
                    result = jsonObject.get("value").getAsByte();
                    break;
                }
                case "Float": {
                    result = Float.valueOf(jsonObject.get("value").getAsFloat());
                    break;
                }
                case "Double": {
                    result = jsonObject.get("value").getAsDouble();
                    break;
                }
                default: {
                    System.out.println("Unknown number type: " + jsonObject.get("type"));
                    break;
                }
            }
        } else {
            Number temp = inElement.getAsNumber();
            switch (this.numberType) {
                case "double": {
                    result = temp.doubleValue();
                    break;
                }
                case "float": {
                    result = Float.valueOf(temp.floatValue());
                    break;
                }
                case "int": {
                    result = temp.intValue();
                    break;
                }
                case "long": {
                    result = temp.longValue();
                    break;
                }
                case "short": {
                    result = temp.shortValue();
                    break;
                }
                case "byte": {
                    result = temp.byteValue();
                    break;
                }
                default: {
                    result = temp;
                }
            }
        }
        return result;
    }
}

