/*
 * Decompiled with CFR 0.152.
 */
package dk.cavi.eventbus.core.ui;

import dk.cavi.eventbus.core.FilterInterface;
import dk.cavi.eventbus.core.annotations.UIGroup;
import dk.cavi.eventbus.core.annotations.UIParameter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class AutoControlPanelUI
extends JPanel {
    private int currentY = 0;
    private final GridBagConstraints labelConstraints;
    private final GridBagConstraints valueConstraints;
    private final GridBagConstraints noteConstraints;
    private final GridBagConstraints headerConstraints;
    private int lastGroup = Integer.MIN_VALUE;

    public AutoControlPanelUI(FilterInterface filter) {
        this.headerConstraints = new GridBagConstraints();
        this.headerConstraints.gridx = 0;
        this.headerConstraints.gridwidth = 2;
        this.headerConstraints.anchor = 21;
        this.headerConstraints.insets = new Insets(0, 4, 0, 0);
        this.labelConstraints = new GridBagConstraints();
        this.labelConstraints.gridx = 0;
        this.labelConstraints.weightx = 0.25;
        this.labelConstraints.anchor = 22;
        this.labelConstraints.insets = new Insets(0, 0, 0, 4);
        this.valueConstraints = new GridBagConstraints();
        this.valueConstraints.gridx = 1;
        this.valueConstraints.weightx = 1.0;
        this.valueConstraints.fill = 2;
        this.valueConstraints.insets = new Insets(2, 4, 2, 4);
        this.noteConstraints = new GridBagConstraints();
        this.noteConstraints.gridx = 1;
        this.noteConstraints.weightx = 1.0;
        this.noteConstraints.anchor = 22;
        this.noteConstraints.insets = new Insets(2, 4, 2, 4);
        this.initComponents();
        this.createUI(filter);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void createUI(FilterInterface filter) {
        this.setLayout(new GridBagLayout());
        Arrays.stream(filter.getClass().getDeclaredFields()).filter(field -> field.isAnnotationPresent(UIParameter.class)).sorted((field1, field2) -> {
            UIParameter param1 = field1.getAnnotation(UIParameter.class);
            UIParameter param2 = field2.getAnnotation(UIParameter.class);
            if (param1.group() != param2.group()) {
                return Integer.compare(param1.group(), param2.group());
            }
            return Integer.compare(param1.order(), param2.order());
        }).forEachOrdered(field -> {
            UIParameter param = field.getAnnotation(UIParameter.class);
            if (this.lastGroup != param.group()) {
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.gridy = this.currentY;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.gridwidth = 0;
                constraints.gridheight = 1;
                constraints.fill = 1;
                this.add(Box.createVerticalStrut(this.lastGroup == Integer.MIN_VALUE ? 5 : 20), constraints);
                ++this.currentY;
                Arrays.stream(filter.getClass().getDeclaredFields()).filter(groupingField -> groupingField.isAnnotationPresent(UIGroup.class) && groupingField.getAnnotation(UIGroup.class).group() == param.group()).findFirst().ifPresent(foundField -> {
                    this.headerConstraints.gridy = this.currentY++;
                    this.add((Component)new JLabel(foundField.getAnnotation(UIGroup.class).label()), this.headerConstraints);
                });
            }
            this.lastGroup = param.group();
            this.addField(filter, (Field)field);
        });
    }

    private void addField(FilterInterface filter, Field field) {
        String fieldGetMethodName = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        try {
            Object fieldValue = null;
            try {
                Method fieldGetMethod = filter.getClass().getMethod(fieldGetMethodName, new Class[0]);
                fieldValue = fieldGetMethod.invoke((Object)filter, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                field.setAccessible(true);
                fieldValue = field.get(filter);
            }
            UIParameter uiParam = field.getAnnotation(UIParameter.class);
            JLabel label = new JLabel();
            if (!uiParam.label().isEmpty()) {
                label.setText(uiParam.label());
            } else {
                label.setText(field.getName());
            }
            this.labelConstraints.gridy = this.currentY;
            this.add((Component)label, this.labelConstraints);
            label.setMinimumSize(label.getPreferredSize());
            JComponent inputComponent = AutoControlPanelUI.createInputComponent(filter, uiParam, field, fieldValue);
            this.valueConstraints.gridy = this.currentY;
            if (!uiParam.tooltip().isEmpty()) {
                inputComponent.setToolTipText("<html>" + uiParam.tooltip() + "</html>");
            }
            this.add((Component)inputComponent, this.valueConstraints);
            if (!uiParam.footnote().isEmpty()) {
                ++this.currentY;
                JLabel footnoteLabel = new JLabel(uiParam.footnote());
                footnoteLabel.setEnabled(false);
                this.noteConstraints.gridy = this.currentY;
                this.add((Component)footnoteLabel, this.noteConstraints);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            System.out.println("Error adding field to auto control panel.");
            e.printStackTrace();
        }
        ++this.currentY;
    }

    private static FieldType getFieldTypeFromClass(Class typeClass) {
        if (typeClass == Double.class || typeClass == Double.TYPE) {
            return FieldType.Double;
        }
        if (typeClass == Float.class || typeClass == Float.TYPE) {
            return FieldType.Float;
        }
        if (typeClass == Integer.class || typeClass == Integer.TYPE) {
            return FieldType.Integer;
        }
        if (typeClass == Short.class || typeClass == Short.TYPE) {
            return FieldType.Short;
        }
        if (typeClass == Long.class || typeClass == Long.TYPE) {
            return FieldType.Long;
        }
        if (typeClass == Boolean.class || typeClass == Boolean.TYPE) {
            return FieldType.Boolean;
        }
        if (typeClass == String.class) {
            return FieldType.String;
        }
        if (Enum.class.isAssignableFrom(typeClass)) {
            return FieldType.Enum;
        }
        return FieldType.Unknown;
    }

    public static JComponent createInputComponent(FilterInterface filter, UIParameter parameter, Field field, Object fieldValue) {
        UIParameter.Type parameterType = parameter.type();
        FieldType fieldType = AutoControlPanelUI.getFieldTypeFromClass(field.getType());
        if (fieldValue == null) {
            fieldValue = "";
        }
        if (parameterType == UIParameter.Type.DEFAULT) {
            switch (fieldType) {
                case Double: 
                case Integer: 
                case Float: 
                case Short: 
                case Long: {
                    parameterType = UIParameter.Type.JSpinner;
                    break;
                }
                case Boolean: {
                    parameterType = UIParameter.Type.JCheckBox;
                    break;
                }
                case Enum: {
                    parameterType = UIParameter.Type.Dropdown;
                    break;
                }
                default: {
                    parameterType = UIParameter.Type.JTextField;
                }
            }
        }
        JComponent inputComponent = null;
        switch (parameterType) {
            case JTextField: {
                JTextField input = new JTextField(fieldValue.toString());
                input.addCaretListener(caretEvent -> AutoControlPanelUI.updateFieldValueFromString(filter, field, input.getText()));
                inputComponent = input;
                break;
            }
            case JSpinner: {
                switch (fieldType) {
                    case Boolean: 
                    case String: {
                        throw new IllegalStateException("Only number field types can be JSpinner");
                    }
                }
                JSpinner input = new JSpinner();
                input.setModel(new SpinnerNumberModel((Number)fieldValue, null, null, (Number)parameter.stepSize()));
                input.setValue(fieldValue);
                input.addChangeListener(changeEvent -> AutoControlPanelUI.updateFieldValueFromString(filter, field, input.getValue().toString()));
                inputComponent = input;
                break;
            }
            case JCheckBox: {
                if (fieldType != FieldType.Boolean) {
                    throw new IllegalStateException("Only fields of type Boolean can be JCheckBox inputs.");
                }
                JCheckBox input = new JCheckBox();
                input.setSelected(Boolean.parseBoolean(fieldValue.toString()));
                input.addChangeListener(changeEvent -> AutoControlPanelUI.updateFieldValueFromString(filter, field, "" + input.isSelected()));
                inputComponent = input;
                break;
            }
            case Dropdown: {
                if (fieldType != FieldType.Enum) {
                    throw new IllegalStateException("Only fields of type Enum can be Dropdown inputs.");
                }
                JComboBox<Enum> input = new JComboBox<Enum>();
                try {
                    Enum[] enumValues;
                    Method valuesMethod = field.getType().getMethod("values", new Class[0]);
                    for (Enum value : enumValues = (Enum[])valuesMethod.invoke((Object)field, new Object[0])) {
                        input.addItem(value);
                    }
                    input.addItemListener(itemEvent -> AutoControlPanelUI.updateFieldValueFromString(filter, field, "" + input.getSelectedItem()));
                    input.setSelectedItem(fieldValue);
                    inputComponent = input;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            default: {
                System.out.println("Unhandeled component type: " + (Object)((Object)parameterType));
            }
        }
        return inputComponent;
    }

    private static void updateFieldValueFromString(FilterInterface filter, Field field, String value) {
        FieldType fieldType = AutoControlPanelUI.getFieldTypeFromClass(field.getType());
        try {
            String fieldGetMethodName = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            String fieldSetMethodName = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            Method fieldGetMethod = null;
            Method fieldSetMethod = null;
            try {
                fieldSetMethod = filter.getClass().getMethod(fieldSetMethodName, field.getType());
            }
            catch (NoSuchMethodException e) {
                System.out.println("Unable to find set method...");
            }
            Object oldValue = null;
            try {
                fieldGetMethod = filter.getClass().getMethod(fieldGetMethodName, new Class[0]);
                oldValue = fieldGetMethod.invoke((Object)filter, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                System.out.println("Direct access..");
                field.setAccessible(true);
                oldValue = field.get(filter);
            }
            if (oldValue == null) {
                oldValue = "";
            }
            switch (fieldType) {
                case Boolean: {
                    boolean parsedValue = Boolean.parseBoolean(value);
                    if ((Boolean)oldValue != parsedValue) {
                        if (fieldSetMethod != null) {
                            fieldSetMethod.invoke((Object)filter, parsedValue);
                        } else {
                            field.setAccessible(true);
                            field.setBoolean(filter, parsedValue);
                        }
                        filter.makeDirty();
                    }
                    break;
                }
                case Double: {
                    double parsedValue = Double.parseDouble(value);
                    if ((Double)oldValue != parsedValue) {
                        if (fieldSetMethod != null) {
                            fieldSetMethod.invoke((Object)filter, parsedValue);
                        } else {
                            field.setAccessible(true);
                            field.setDouble(filter, parsedValue);
                        }
                        filter.makeDirty();
                    }
                    break;
                }
                case Float: {
                    float parsedValue = Float.parseFloat(value);
                    if (((Float)oldValue).floatValue() != parsedValue) {
                        if (fieldSetMethod != null) {
                            fieldSetMethod.invoke((Object)filter, Float.valueOf(parsedValue));
                        } else {
                            field.setAccessible(true);
                            field.setFloat(filter, parsedValue);
                        }
                        filter.makeDirty();
                    }
                    break;
                }
                case Integer: {
                    int parsedValue = Integer.parseInt(value);
                    if ((Integer)oldValue != parsedValue) {
                        if (fieldSetMethod != null) {
                            fieldSetMethod.invoke((Object)filter, parsedValue);
                        } else {
                            field.setAccessible(true);
                            field.setInt(filter, parsedValue);
                        }
                        filter.makeDirty();
                    }
                    break;
                }
                case Short: {
                    short parsedValue = Short.parseShort(value);
                    if ((Short)oldValue != parsedValue) {
                        if (fieldSetMethod != null) {
                            fieldSetMethod.invoke((Object)filter, parsedValue);
                        } else {
                            field.setAccessible(true);
                            field.setShort(filter, parsedValue);
                        }
                        filter.makeDirty();
                    }
                    break;
                }
                case Long: {
                    long parsedValue = Long.parseLong(value);
                    if ((Long)oldValue != parsedValue) {
                        if (fieldSetMethod != null) {
                            fieldSetMethod.invoke((Object)filter, parsedValue);
                        } else {
                            field.setAccessible(true);
                            field.setLong(filter, parsedValue);
                        }
                        filter.makeDirty();
                    }
                    break;
                }
                case Enum: {
                    Object parsedValue = Enum.valueOf(field.getType(), value);
                    if ((Enum)oldValue != parsedValue) {
                        if (fieldSetMethod != null) {
                            fieldSetMethod.invoke((Object)filter, parsedValue);
                        } else {
                            field.setAccessible(true);
                            field.set(filter, parsedValue);
                        }
                        filter.makeDirty();
                    }
                    break;
                }
                case String: {
                    String parsedValue = value;
                    if (!((String)oldValue).equals(parsedValue)) {
                        if (fieldSetMethod != null) {
                            fieldSetMethod.invoke((Object)filter, parsedValue);
                        } else {
                            field.setAccessible(true);
                            field.set(filter, parsedValue);
                        }
                        filter.makeDirty();
                    }
                    break;
                }
                default: {
                    System.out.println("Unknown field type: " + (Object)((Object)fieldType));
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error setting value on field: [" + field.getName() + " - " + field.getType() + "] - " + value);
            e.printStackTrace();
        }
    }

    private static enum FieldType {
        Double,
        Integer,
        Float,
        Short,
        Long,
        Boolean,
        String,
        Enum,
        Unknown;

    }
}

